/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class UndoRedoMessage
implements IMessage {
    private final int id;
    private final boolean undo;

    public UndoRedoMessage(int id, boolean undo) {
        this.undo = undo;
        this.id = id;
    }

    public UndoRedoMessage(PacketBuffer buf) {
        this.id = buf.readInt();
        this.undo = buf.readBoolean();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.undo);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().func_184812_l_()) {
            return;
        }
        if (this.undo) {
            Manager.undo((PlayerEntity)ctxIn.getSender(), this.id);
        } else {
            Manager.redo((PlayerEntity)ctxIn.getSender(), this.id);
        }
    }
}

