/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant.fertilizer;

import com.agricraft.agricore.plant.fertilizer.AgriPlantList;
import com.agricraft.agricore.plant.particle.AgriFertilizerParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AgriFertilizerEffect {
    private final boolean reduce_growth;
    private final boolean kill_plant;
    private final AgriPlantList negatively_affected;
    private final AgriPlantList positively_affected;
    private final List<AgriFertilizerParticle> particles;

    public AgriFertilizerEffect() {
        this.reduce_growth = true;
        this.kill_plant = true;
        this.negatively_affected = new AgriPlantList();
        this.positively_affected = new AgriPlantList();
        this.particles = new ArrayList<AgriFertilizerParticle>();
    }

    public AgriFertilizerEffect(boolean reduce_growth, boolean kill_plant, AgriPlantList negatively_affected, AgriPlantList positively_affected, List<AgriFertilizerParticle> particles) {
        this.reduce_growth = reduce_growth;
        this.kill_plant = kill_plant;
        this.negatively_affected = negatively_affected;
        this.positively_affected = positively_affected;
        this.particles = particles;
    }

    public boolean canReduceGrowth() {
        return this.reduce_growth;
    }

    public boolean canKillPlant() {
        return this.kill_plant;
    }

    public boolean canFertilize(String plantId) {
        return this.positively_affected.isAffected(plantId) || this.negatively_affected.isAffected(plantId);
    }

    public boolean isNegativelyAffected(String plantId) {
        return this.negatively_affected.isAffected(plantId);
    }

    public List<AgriFertilizerParticle> getParticles(String type) {
        return this.particles.stream().filter(particle -> particle.shouldSpawn(type)).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nAgriFertilizerEffect:");
        sb.append("\n\t- Reduce Growth: ").append(this.reduce_growth);
        sb.append("\n\t- Kill Plant: ").append(this.kill_plant);
        sb.append("\n\t- Negatively Affected: ").append(this.negatively_affected.toString().replaceAll("\n", "\n\t").trim());
        sb.append("\n\t- Positively Affected: ").append(this.positively_affected.toString().replaceAll("\n", "\n\t").trim());
        sb.append("\n\t- Particles: \n\t").append(this.particles.stream().collect(StringBuilder::new, (builder, item) -> builder.append("\n\t").append(item), StringBuilder::append).toString().replaceAll("\n", "\n\t").trim());
        return sb.toString();
    }

    public boolean validate() {
        this.particles.removeIf(particle -> !particle.validate());
        return this.negatively_affected.validate() && this.positively_affected.validate();
    }
}

