/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.plant;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class AgriPlantIngredient
extends Ingredient {
    private final IAgriPlant plant;
    private ItemStack[] stacks;

    public AgriPlantIngredient(IAgriPlant plant) {
        super(Stream.of(new Ingredient.SingleItemList(plant.toItemStack())));
        this.plant = plant;
    }

    public String getPlantId() {
        return this.getPlant().getId();
    }

    public IAgriPlant getPlant() {
        return this.plant;
    }

    public boolean isValid() {
        return this.getPlant().isPlant();
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.stacks == null) {
            if (this.isValid()) {
                this.stacks = new ItemStack[]{this.getPlant().toItemStack()};
            } else {
                return new ItemStack[0];
            }
        }
        return this.stacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IAgriSeedItem && this.isValid() && ((IAgriSeedItem)stack.func_77973_b()).getPlant(stack).equals(this.getPlant());
    }

    @Nonnull
    public IIngredientSerializer<AgriPlantIngredient> getSerializer() {
        return AgriApi.getPlantIngredientSerializer();
    }
}

