/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.event.AgriCropEvent;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatProvider;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.core.BlockCropBase;
import com.infinityraider.agricraft.impl.v1.CoreHandler;
import com.infinityraider.agricraft.impl.v1.crop.NoGrowth;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.impl.v1.plant.NoWeed;
import com.infinityraider.agricraft.impl.v1.requirement.RequirementCache;
import com.infinityraider.agricraft.impl.v1.stats.NoStats;
import com.infinityraider.agricraft.util.CropHelper;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class TileEntityCropBase
extends TileEntityBase
implements IAgriCrop,
IDebuggable {
    public static final ModelProperty<IAgriPlant> PROPERTY_PLANT = new ModelProperty();
    public static final ModelProperty<IAgriGrowthStage> PROPERTY_PLANT_GROWTH = new ModelProperty();
    public static final ModelProperty<IAgriWeed> PROPERTY_WEED = new ModelProperty();
    public static final ModelProperty<IAgriGrowthStage> PROPERTY_WEED_GROWTH = new ModelProperty();
    private static final IAgriPlant NO_PLANT = NoPlant.getInstance();
    private static final IAgriGrowthStage NO_GROWTH = NoGrowth.getInstance();
    private static final IAgriWeed NO_WEED = NoWeed.getInstance();
    private static final IAgriStatsMap NO_STATS = NoStats.getInstance();
    private final ModelDataMap data = new ModelDataMap.Builder().withInitial(PROPERTY_PLANT, (Object)NO_PLANT).withInitial(PROPERTY_PLANT_GROWTH, (Object)NO_GROWTH).withInitial(PROPERTY_WEED, (Object)NO_WEED).withInitial(PROPERTY_WEED_GROWTH, (Object)NO_GROWTH).build();
    private final TileEntityBase.AutoSyncedField<Optional<IAgriGenome>> genome = this.createAutoSyncedField(Optional.empty(), (optional, tag) -> optional.ifPresent(genome -> {
        CompoundNBT geneTag = new CompoundNBT();
        genome.writeToNBT(geneTag);
        tag.func_218657_a("agri_genome", (INBT)geneTag);
    }), tag -> {
        if (tag.func_74764_b("agri_genome")) {
            IAgriGenome genome = AgriApi.getAgriGenomeBuilder(NO_PLANT).build();
            genome.readFromNBT(tag.func_74775_l("agri_genome"));
            return Optional.of(genome);
        }
        return Optional.empty();
    }, CoreHandler::isInitialized, Optional.empty());
    private final TileEntityBase.AutoSyncedField<IAgriGrowthStage> growth = this.getAutoSyncedFieldBuilder(NO_GROWTH, (growth, tag) -> tag.func_74778_a("agri_growth", growth.getId()), tag -> AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_growth")).orElse(NO_GROWTH), CoreHandler::isInitialized, NO_GROWTH).withCallBack(stage -> {
        this.getModelData().setData(PROPERTY_PLANT_GROWTH, stage);
        this.requirement = RequirementCache.create(this);
    }).withRenderUpdate().build();
    private final TileEntityBase.AutoSyncedField<IAgriWeed> weed = this.getAutoSyncedFieldBuilder(NO_WEED, (weed, tag) -> tag.func_74778_a("agri_weed", weed.getId()), tag -> AgriApi.getWeedRegistry().get(tag.func_74779_i("agri_weed")).orElse(NO_WEED), CoreHandler::isInitialized, NO_WEED).withCallBack(weed -> {
        IAgriWeed cfr_ignored_0 = (IAgriWeed)this.getModelData().setData(PROPERTY_WEED, weed);
    }).withRenderUpdate().build();
    private final TileEntityBase.AutoSyncedField<IAgriGrowthStage> weedGrowth = this.getAutoSyncedFieldBuilder(NO_GROWTH, (growth, tag) -> tag.func_74778_a("agri_weed_growth", growth.getId()), tag -> AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_weed_growth")).orElse(NO_GROWTH), CoreHandler::isInitialized, NO_GROWTH).withCallBack(stage -> {
        IAgriGrowthStage cfr_ignored_0 = (IAgriGrowthStage)this.getModelData().setData(PROPERTY_WEED_GROWTH, stage);
    }).withRenderUpdate().build();
    private RequirementCache requirement = RequirementCache.create(this);
    private final LazyOptional<IAgriCrop> cropCapability = LazyOptional.of(() -> this);

    public TileEntityCropBase(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void dropItem(ItemStack item) {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        this.func_145831_w().func_217376_c((Entity)new ItemEntity(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), item));
    }

    @Override
    public boolean isValid() {
        return this.func_145831_w() != null && !this.func_145837_r();
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public FluidState getFluidState() {
        return this.func_195044_w().func_204520_s();
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getGrowthStage() {
        return (IAgriGrowthStage)this.growth.get();
    }

    @Override
    public boolean setGrowthStage(@Nonnull IAgriGrowthStage stage) {
        if (((IAgriGrowthStage)this.growth.get()).equals(stage)) {
            return false;
        }
        if (!this.getPlant().getGrowthStages().contains(stage)) {
            return false;
        }
        if (!this.checkGrowthSpace(this.getPlant(), stage)) {
            return false;
        }
        this.growth.set((Object)stage);
        this.handlePlantUpdate();
        return true;
    }

    protected boolean checkGrowthSpace(IAgriGrowable plant, IAgriGrowthStage stage) {
        return CropHelper.checkGrowthSpace(this.func_145831_w(), this.func_174877_v(), plant, stage);
    }

    @Override
    public IAgriGrowthResponse getFertilityResponse() {
        if (this.func_145831_w() == null) {
            return IAgriGrowthResponse.INFERTILE;
        }
        if (!this.checkGrowthSpace(this.getPlant(), this.getGrowthStage())) {
            return IAgriGrowthResponse.INFERTILE;
        }
        return this.requirement.check();
    }

    @Override
    public boolean isMature() {
        return this.getGrowthStage().isMature();
    }

    @Override
    public boolean isFullyGrown() {
        return this.getGrowthStage().isFinal();
    }

    @Override
    @Nonnull
    public Optional<IAgriSoil> getSoil() {
        return Optional.ofNullable(this.func_145831_w()).flatMap(world -> AgriApi.getSoil((IBlockReader)world, this.getPosition().func_177977_b()));
    }

    @Override
    public void breakCrop(@Nullable LivingEntity entity) {
        if (this.func_145831_w() == null) {
            return;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Break.Pre(this, entity))) {
            IAgriPlant plant = this.getPlant();
            IAgriWeed weed = this.getWeeds();
            Block.func_220059_a((BlockState)this.func_195044_w(), (IWorld)this.func_145831_w(), (BlockPos)this.getPosition(), (TileEntity)this);
            this.func_145831_w().func_175656_a(this.getPosition(), Blocks.field_150350_a.func_176223_P());
            plant.onBroken(this, entity);
            weed.onBroken(this, entity);
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Break.Post(this, entity));
        }
    }

    @Override
    public void applyGrowthTick() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.General.Pre(this))) {
            if (this.rollForWeedAction()) {
                this.executeWeedGrowthTick();
            } else if (this.isCrossCrop()) {
                this.executeCrossGrowthTick();
            } else {
                IAgriGrowthResponse fertility = this.getFertilityResponse();
                if (fertility.killInstantly()) {
                    fertility.onPlantKilled(this);
                    this.removeGenome();
                } else if (fertility.isLethal()) {
                    this.revertGrowthStage();
                } else if (fertility.isFertile()) {
                    this.executePlantGrowthTick();
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.General.Post(this));
        }
    }

    protected boolean rollForWeedAction() {
        return CropHelper.rollForWeedAction(this);
    }

    protected void executeWeedGrowthTick() {
        if (!MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.Weeds.Pre(this))) {
            if (!this.hasWeeds()) {
                this.spawnWeeds();
            } else if (this.getWeedGrowthStage().isFinal()) {
                this.tryWeedKillPlant();
                this.spreadWeeds();
            } else {
                double f = this.getSoil().map(IAgriSoil::getGrowthModifier).orElse(1.0);
                if (this.getRandom().nextDouble() < f * this.getWeeds().getGrowthChance(this.getWeedGrowthStage())) {
                    this.setWeed(this.getWeeds(), this.getWeedGrowthStage().getNextStage(this, this.getRandom()));
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.Weeds.Post(this));
        }
    }

    protected void spawnWeeds() {
        CropHelper.spawnWeeds(this);
    }

    protected void spreadWeeds() {
        CropHelper.spreadWeeds(this);
    }

    protected void tryWeedKillPlant() {
        if (((Config)AgriCraft.instance.getConfig()).allowLethalWeeds() && this.getWeeds().isLethal() && this.hasPlant() && this.rollForWeedAction()) {
            this.revertGrowthStage();
        }
    }

    protected void revertGrowthStage() {
        IAgriGrowthStage previous;
        IAgriGrowthStage current = this.getGrowthStage();
        if (current.equals(previous = current.getPreviousStage(this, this.getRandom()))) {
            this.removeGenome();
        } else {
            this.setGrowthStage(previous);
        }
    }

    protected void executeCrossGrowthTick() {
        if (!this.hasWeeds() && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.Cross.Pre(this)) && AgriApi.getAgriMutationHandler().getActiveMutationEngine().handleMutationTick(this, this.streamNeighbours(), this.getRandom())) {
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.Cross.Post(this));
        }
    }

    protected void executePlantGrowthTick() {
        if (!this.getGrowthStage().isFinal()) {
            BlockState state = this.func_195044_w();
            if (this.calculateGrowthRate() > this.getRandom().nextDouble() && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.Plant.Pre(this))) {
                BlockEvent.CropGrowEvent.Pre blockEvent = new BlockEvent.CropGrowEvent.Pre(this.func_145831_w(), this.func_174877_v(), state);
                MinecraftForge.EVENT_BUS.post((Event)blockEvent);
                if (blockEvent.getResult() == Event.Result.ALLOW || blockEvent.getResult() == Event.Result.DEFAULT) {
                    this.setGrowthStage(this.getGrowthStage().getNextStage(this, this.getRandom()));
                    this.getPlant().onGrowth(this);
                    MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Grow.Plant.Post(this));
                    MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.CropGrowEvent.Post(this.func_145831_w(), this.func_174877_v(), state, state));
                }
            }
        }
    }

    protected double calculateGrowthRate() {
        int growth = this.getStats().getGrowth();
        double soilFactor = this.getSoil().map(IAgriSoil::getGrowthModifier).orElse(1.0);
        return soilFactor * (this.getPlant().getGrowthChanceBase(this.getGrowthStage()) + (double)growth * this.getPlant().getGrowthChanceBonus(this.getGrowthStage()) * ((Config)AgriCraft.instance.getConfig()).growthMultiplier());
    }

    @Override
    @Nonnull
    public Optional<IAgriGenome> getGenome() {
        return (Optional)this.genome.get();
    }

    @Override
    @Nonnull
    public IAgriStatsMap getStats() {
        return this.getGenome().map(IAgriStatProvider::getStats).orElse(NO_STATS);
    }

    @Override
    public boolean acceptsFertilizer(@Nonnull IAgriFertilizer fertilizer) {
        Objects.requireNonNull(fertilizer);
        if (this.isCrossCrop()) {
            return ((Config)AgriCraft.instance.getConfig()).allowFertilizerMutations() && fertilizer.canTriggerMutation();
        }
        if (this.hasPlant()) {
            return !this.isFullyGrown() && fertilizer.canFertilize(this) && this.getPlant().isFertilizable(this.getGrowthStage(), fertilizer);
        }
        return fertilizer.canTriggerWeeds();
    }

    @Override
    public void onApplyFertilizer(@Nonnull IAgriFertilizer fertilizer, @Nonnull Random rand) {
    }

    @Override
    public boolean canBeHarvested(@Nullable LivingEntity entity) {
        return this.getPlant().allowsHarvest(this.getGrowthStage(), entity);
    }

    @Override
    @Nonnull
    public ActionResultType harvest(@Nonnull Consumer<ItemStack> consumer, LivingEntity entity) {
        if (this.func_145831_w() != null && this.canBeHarvested(entity) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Harvest.Pre(this, entity))) {
            CropHelper.executePlantHarvestRolls(this, consumer);
            this.setGrowthStage(this.getPlant().getGrowthStageAfterHarvest());
            this.getPlant().onHarvest(this, entity);
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Harvest.Post(this, entity));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean canBeRaked(@Nonnull IAgriRakeItem item, @Nonnull ItemStack stack, @Nullable LivingEntity entity) {
        return this.getWeeds().isWeed();
    }

    @Override
    public boolean rake(@Nonnull Consumer<ItemStack> consumer, @Nullable LivingEntity entity) {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return false;
        }
        IAgriWeed weed = this.getWeeds();
        if (weed.isWeed()) {
            IAgriGrowthStage stage = this.getWeedGrowthStage();
            this.setWeed(NO_WEED, NO_GROWTH);
            weed.onRake(stage, consumer, this.getRandom(), entity);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPlant() {
        return this.getGenome().map(IAgriGenome::getPlant).map(IAgriPlant::isPlant).orElse(false);
    }

    @Override
    @Nonnull
    public IAgriPlant getPlant() {
        return this.getGenome().map(IAgriGenome::getPlant).orElse(NO_PLANT);
    }

    @Override
    public boolean hasWeeds() {
        return ((IAgriWeed)this.weed.get()).isWeed();
    }

    @Override
    @Nonnull
    public IAgriWeed getWeeds() {
        return (IAgriWeed)this.weed.get();
    }

    @Override
    @Nonnull
    public IAgriGrowthStage getWeedGrowthStage() {
        return (IAgriGrowthStage)this.weedGrowth.get();
    }

    @Override
    public boolean setWeed(@Nonnull IAgriWeed weed, @Nonnull IAgriGrowthStage stage) {
        if (this.getWeeds().equals(weed)) {
            if (((IAgriGrowthStage)this.weedGrowth.get()).equals(stage)) {
                return false;
            }
            if (this.getWeeds().getGrowthStages().contains(stage) && this.checkGrowthSpace(this.getWeeds(), stage)) {
                this.weedGrowth.set((Object)stage);
                this.getWeeds().onGrowthTick(this);
                this.handlePlantUpdate();
                return true;
            }
            return false;
        }
        if (weed.getGrowthStages().contains(stage) && this.checkGrowthSpace(this.getWeeds(), stage) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Weed.Pre((IAgriCrop)this, weed))) {
            this.setWeedImpl(weed, stage);
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Weed.Post((IAgriCrop)this, weed));
            return true;
        }
        return false;
    }

    protected void setWeedImpl(@Nonnull IAgriWeed weed, @Nonnull IAgriGrowthStage stage) {
        this.weed.set((Object)weed);
        this.weedGrowth.set((Object)stage);
        this.getWeeds().onSpawned(this);
        this.handlePlantUpdate();
    }

    @Override
    public boolean removeWeed() {
        if (this.hasWeeds()) {
            this.weed.set((Object)NO_WEED);
            this.weedGrowth.set((Object)NO_GROWTH);
            this.handlePlantUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsGenome(@Nonnull IAgriGenome genome) {
        return !this.hasGenome() && !this.isCrossCrop();
    }

    @Override
    public boolean spawnGenome(@Nonnull IAgriGenome genome) {
        if (!(this.hasPlant() || this.isCrossCrop() || MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Plant.Pre((IAgriCrop)this, genome)))) {
            this.setGenomeImpl(genome);
            this.getPlant().onSpawned(this);
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Plant.Post((IAgriCrop)this, genome));
            return true;
        }
        return false;
    }

    @Override
    public boolean plantGenome(@Nonnull IAgriGenome genome) {
        return this.plantGenome(genome, null);
    }

    @Override
    public boolean plantGenome(@Nonnull IAgriGenome genome, @Nullable LivingEntity entity) {
        if (this.acceptsGenome(genome) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Plant.Pre(this, genome, entity))) {
            this.setGenomeImpl(genome);
            if (this.func_145831_w() != null) {
                CropHelper.playPlantingSound(this.func_145831_w(), this.func_174877_v(), entity instanceof PlayerEntity ? (PlayerEntity)entity : null);
            }
            this.getPlant().onPlanted(this, entity);
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Plant.Post(this, genome, entity));
            return true;
        }
        return false;
    }

    protected void setGenomeImpl(@Nonnull IAgriGenome genome) {
        this.genome.set(Optional.of(genome));
        this.growth.set((Object)genome.getPlant().getInitialGrowthStage());
        this.handlePlantUpdate();
    }

    @Override
    public boolean removeGenome() {
        if (this.hasGenome()) {
            this.getPlant().onRemoved(this);
            this.genome.set(Optional.empty());
            this.handlePlantUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGenome() {
        return this.hasPlant();
    }

    protected void writeTileNBT(@Nonnull CompoundNBT tag) {
    }

    protected void readTileNBT(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
    }

    protected void handlePlantUpdate() {
        if (this.func_145831_w() != null) {
            boolean plant;
            BlockState oldState;
            BlockState newState = oldState = this.func_195044_w();
            int brightness = this.getPlant().getBrightness(this);
            if ((Integer)BlockCropBase.LIGHT.fetch(newState) != brightness) {
                newState = BlockCropBase.LIGHT.apply(newState, (Comparable)Integer.valueOf(brightness));
            }
            boolean bl = plant = this.hasPlant() || this.hasWeeds();
            if ((Boolean)BlockCropBase.PLANT.fetch(newState) != plant) {
                newState = BlockCropBase.PLANT.apply(newState, (Comparable)Boolean.valueOf(plant));
            }
            if (newState != oldState) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), newState);
            }
            this.requirement.flush();
            this.requirement = RequirementCache.create(this);
            this.getModelData().setData(PROPERTY_PLANT, (Object)this.getPlant());
            this.getModelData().setData(PROPERTY_PLANT_GROWTH, (Object)this.getGrowthStage());
            this.getModelData().setData(PROPERTY_WEED, (Object)this.getWeeds());
            this.getModelData().setData(PROPERTY_WEED_GROWTH, (Object)this.getWeedGrowthStage());
        }
    }

    public void mimicFrom(IAgriCrop other) {
        other.getGenome().ifPresent(genome -> {
            this.setGenomeImpl(genome.clone());
            this.setGrowthStage(other.getGrowthStage());
        });
        this.setWeedImpl(other.getWeeds(), other.getWeedGrowthStage());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CropCapability.getCapability()) {
            return this.cropCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onChunkUnloaded() {
        this.requirement.flush();
        super.onChunkUnloaded();
    }

    public void func_145843_s() {
        this.requirement.flush();
        super.func_145843_s();
    }

    public void addServerDebugInfo(@Nonnull Consumer<String> consumer) {
        Preconditions.checkNotNull(consumer);
        consumer.accept("CROP:");
        if (this.hasCropSticks()) {
            consumer.accept(" - Crop Sticks Present");
        }
        if (this.isCrossCrop()) {
            consumer.accept(" - This is a cross crop");
        } else {
            IAgriPlant plant = this.getPlant();
            IAgriWeed weed = this.getWeeds();
            IAgriStatsMap stats = this.getStats();
            if (plant.isPlant()) {
                consumer.accept(" - This crop has a plant");
            }
            if (weed.isWeed()) {
                consumer.accept(" - This crop has weeds");
            }
            consumer.accept(" - Plant Id: " + plant.getId());
            consumer.accept(" - Plant Stage: " + this.getGrowthStage());
            consumer.accept(" - Plant Stages: " + plant.getGrowthStages());
            consumer.accept(" - Weed Id: " + weed.getId());
            consumer.accept(" - Weed Stage: " + this.getWeedGrowthStage());
            consumer.accept(" - Weed Stages: " + weed.getGrowthStages());
            consumer.accept(" - stats: " + stats);
            consumer.accept(" - Fertile: " + this.isFertile());
            consumer.accept(" - Mature: " + this.isMature());
            consumer.accept(" - Fully Grown: " + this.isFullyGrown());
            consumer.accept(" - AgriSoil: " + this.getSoil());
        }
    }

    public void addClientDebugInfo(@Nonnull Consumer<String> consumer) {
        this.addServerDebugInfo(consumer);
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<ITextComponent> consumer) {
        CropHelper.addDisplayInfo(this, this.requirement, consumer);
    }

    @Nonnull
    public final ModelDataMap getModelData() {
        return this.data;
    }
}

