/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.irrigation.BlockIrrigationChannelAbstract;
import com.infinityraider.agricraft.content.irrigation.ItemIrrigationChannelHollow;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockIrrigationChannelHollow
extends BlockIrrigationChannelAbstract {
    private static final Map<BlockState, VoxelShape> SHAPES = Maps.newHashMap();

    public static VoxelShape getShape(BlockState state) {
        return SHAPES.computeIfAbsent(state, aState -> Stream.concat(Stream.of(Shapes.BASE), Arrays.stream(Direction.values()).map(dir -> BlockIrrigationChannelHollow.getConnection(dir).map(prop -> {
            if (!((Boolean)prop.fetch(aState)).booleanValue()) {
                switch (dir) {
                    case NORTH: {
                        return Shapes.NONE_NORTH;
                    }
                    case SOUTH: {
                        return Shapes.NONE_SOUTH;
                    }
                    case WEST: {
                        return Shapes.NONE_WEST;
                    }
                    case EAST: {
                        return Shapes.NONE_EAST;
                    }
                }
            }
            return VoxelShapes.func_197880_a();
        })).filter(Optional::isPresent).map(Optional::get)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }

    public BlockIrrigationChannelHollow() {
        super("irrigation_channel_hollow", false, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_());
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        BlockIrrigationChannelAbstract.Valve valve = (BlockIrrigationChannelAbstract.Valve)((Object)BlockIrrigationChannelAbstract.VALVE.fetch(state));
        if (valve.hasValve()) {
            boolean isClosed;
            boolean shouldBeClosed = Arrays.stream(Direction.values()).anyMatch(dir -> world.func_175709_b(pos.func_177972_a(dir), dir));
            boolean bl = isClosed = !valve.canTransfer();
            if (shouldBeClosed != isClosed) {
                world.func_175656_a(pos, BlockIrrigationChannelAbstract.VALVE.apply(state, (Comparable)((Object)valve.toggleValve())));
                if (!world.func_201670_d()) {
                    this.playValveSound(world, pos);
                }
            }
        }
    }

    @Nonnull
    public ItemIrrigationChannelHollow asItem() {
        return AgriCraft.instance.getModItemRegistry().channel_hollow;
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220071_b(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_230322_a_(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BlockIrrigationChannelHollow.getShape(state);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    public static final class Shapes {
        public static final VoxelShape BASE = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0), Block.func_208617_a((double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0), Block.func_208617_a((double)10.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)6.0), Block.func_208617_a((double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
        public static final VoxelShape NONE_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
        public static final VoxelShape NONE_SOUTH = NONE_NORTH.func_197751_a(0.0, 0.0, 0.625);
        public static final VoxelShape NONE_WEST = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
        public static final VoxelShape NONE_EAST = NONE_WEST.func_197751_a(0.625, 0.0, 0.0);

        private Shapes() {
        }
    }
}

