/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.irrigation.ItemIrrigationTank;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationTank;
import com.infinityraider.infinitylib.block.BlockDynamicTexture;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockIrrigationTank
extends BlockDynamicTexture<TileEntityIrrigationTank> {
    public static final InfProperty<Connection> NORTH = InfProperty.Creators.create((String)"north", Connection.class, (Enum)Connection.NONE);
    public static final InfProperty<Connection> EAST = InfProperty.Creators.create((String)"east", Connection.class, (Enum)Connection.NONE);
    public static final InfProperty<Connection> SOUTH = InfProperty.Creators.create((String)"south", Connection.class, (Enum)Connection.NONE);
    public static final InfProperty<Connection> WEST = InfProperty.Creators.create((String)"west", Connection.class, (Enum)Connection.NONE);
    public static final InfProperty<Boolean> DOWN = InfProperty.Creators.create((String)"down", (boolean)false);
    public static final InfProperty<Boolean> LADDER = InfProperty.Creators.create((String)"ladder", (boolean)false);
    public static final InfProperty<Boolean> WATER = InfProperty.Creators.create((String)"water", (boolean)false);
    private static final InfPropertyConfiguration PROPERTIES = InfPropertyConfiguration.builder().add(NORTH).add(EAST).add(SOUTH).add(WEST).add(DOWN).add(LADDER).add(WATER).build();
    private static final BiFunction<BlockState, IBlockReader, TileEntityIrrigationTank> TILE_FACTORY = (s, w) -> new TileEntityIrrigationTank();
    public static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final Map<BlockState, VoxelShape> SHAPES = Maps.newConcurrentMap();

    public static Optional<InfProperty<Connection>> getConnection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Optional.of(NORTH);
            }
            case SOUTH: {
                return Optional.of(SOUTH);
            }
            case EAST: {
                return Optional.of(EAST);
            }
            case WEST: {
                return Optional.of(WEST);
            }
        }
        return Optional.empty();
    }

    public static VoxelShape getShape(BlockState state) {
        if (!(state.func_177230_c() instanceof BlockIrrigationTank)) {
            return VoxelShapes.func_197880_a();
        }
        return SHAPES.computeIfAbsent(state, aState -> Stream.concat(Arrays.stream(Direction.values()).filter(direction -> direction.func_176740_k().func_176722_c()).map(direction -> BlockIrrigationTank.getConnection(direction).map(connection -> (Connection)((Object)((Object)((Object)((Object)connection.fetch(aState)))))).map(connection -> connection.getShape((Direction)direction))).filter(Optional::isPresent).map(Optional::get), Stream.of((Boolean)DOWN.fetch(aState) != false ? VoxelShapes.func_197880_a() : SHAPE_DOWN)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).orElse(VoxelShapes.func_197868_b()));
    }

    public BlockIrrigationTank() {
        super("irrigation_tank", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_());
    }

    public ItemIrrigationTank asItem() {
        return AgriCraft.instance.getModItemRegistry().tank;
    }

    protected InfPropertyConfiguration getPropertyConfiguration() {
        return PROPERTIES;
    }

    public BiFunction<BlockState, IBlockReader, TileEntityIrrigationTank> getTileEntityFactory() {
        return TILE_FACTORY;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof BucketItem) {
            TileEntityIrrigationTank tank;
            TileEntity tile;
            BucketItem bucket = (BucketItem)stack.func_77973_b();
            Fluid fluid = bucket.getFluid();
            if (fluid == Fluids.field_204546_a) {
                TileEntityIrrigationTank tank2;
                TileEntity tile2 = world.func_175625_s(pos);
                if (tile2 instanceof TileEntityIrrigationTank && (tank2 = (TileEntityIrrigationTank)tile2).pushWater(1000, false) == 1000) {
                    tank2.pushWater(1000, true);
                    if (!player.func_184812_l_()) {
                        player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                    }
                    return ActionResultType.SUCCESS;
                }
            } else if (fluid == Fluids.field_204541_a && (tile = world.func_175625_s(pos)) instanceof TileEntityIrrigationTank && (tank = (TileEntityIrrigationTank)tile).drainWater(1000, false) == 1000) {
                tank.drainWater(1000, true);
                player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
                return ActionResultType.SUCCESS;
            }
        } else if (stack.func_77973_b() == Items.field_221740_cf && !((Boolean)LADDER.fetch(state)).booleanValue()) {
            if (!world.func_201670_d()) {
                world.func_175656_a(pos, LADDER.apply(state, (Comparable)Boolean.valueOf(true)));
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack, @Nullable TileEntity tile) {
        if (tile instanceof TileEntityIrrigationTank) {
            ((TileEntityIrrigationTank)tile).checkAndFormMultiBlock();
        }
    }

    public BlockState func_196271_a(BlockState ownState, Direction dir, BlockState otherState, IWorld world, BlockPos pos, BlockPos otherPos) {
        return BlockIrrigationTank.getConnection(dir).map(prop -> {
            TileEntityIrrigationChannel channel;
            if (((Connection)((Object)((Object)prop.fetch(ownState)))).isTank()) {
                return ownState;
            }
            TileEntity ownTile = world.func_175625_s(pos);
            TileEntity otherTile = world.func_175625_s(otherPos);
            if (ownTile instanceof TileEntityIrrigationTank && otherTile instanceof TileEntityIrrigationChannel && (channel = (TileEntityIrrigationChannel)otherTile).canConnect((TileEntityIrrigationTank)ownTile)) {
                return prop.apply(ownState, (Comparable)((Object)Connection.CHANNEL));
            }
            return prop.apply(ownState, (Comparable)((Object)Connection.NONE));
        }).orElse(super.func_196271_a(ownState, dir, otherState, world, pos, otherPos));
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityIrrigationTank) {
            TileEntityIrrigationTank tank = (TileEntityIrrigationTank)tile;
            tank.onNeighbourChanged(fromPos);
            tank.onNeighbourUpdate(fromPos);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity tile;
        int rate = ((Config)AgriCraft.instance.getConfig()).rainFillRate();
        if (rate > 0 && (tile = world.func_175625_s(pos)) instanceof TileEntityIrrigationTank) {
            TileEntityIrrigationTank tank = (TileEntityIrrigationTank)tile;
            tank.pushWater(rate, true);
        }
    }

    protected void updateFluidState(World world, BlockPos pos, BlockState state, float waterLevel) {
        boolean hasWater;
        boolean shouldHaveWater = (double)(waterLevel - (float)pos.func_177956_o()) > 0.5;
        if (shouldHaveWater != (hasWater = ((Boolean)WATER.fetch(state)).booleanValue())) {
            world.func_180501_a(pos, WATER.apply(state, (Comparable)Boolean.valueOf(shouldHaveWater)), 54);
        }
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)WATER.fetch(state) != false ? AgriCraft.instance.getModFluidRegistry().tank_water.func_207188_f() : Fluids.field_204541_a.func_207188_f();
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return (Boolean)LADDER.fetch(state);
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220071_b(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_230322_a_(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BlockIrrigationTank.getShape(state);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    public void addDrops(Consumer<ItemStack> dropAcceptor, BlockState state, TileEntityIrrigationTank tile, LootContext.Builder context) {
        if (((Boolean)LADDER.fetch(state)).booleanValue()) {
            dropAcceptor.accept(new ItemStack((IItemProvider)Items.field_221740_cf, 1));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderType getRenderType() {
        return RenderType.func_228643_e_();
    }

    public static enum Connection implements IStringSerializable
    {
        NONE(false, false, Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)),
        TANK(true, false, VoxelShapes.func_197880_a(), VoxelShapes.func_197880_a()),
        CHANNEL(false, true, Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)2.0), Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0), Block.func_208617_a((double)10.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0), Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get(), Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)6.0), Block.func_208617_a((double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());

        private final boolean tank;
        private final boolean channel;
        private final VoxelShape north;
        private final VoxelShape east;
        private final VoxelShape south;
        private final VoxelShape west;

        private Connection(boolean tank, boolean channel, VoxelShape north, VoxelShape west) {
            this.tank = tank;
            this.channel = channel;
            this.north = north;
            this.south = north.func_197751_a(0.0, 0.0, 0.875);
            this.west = west;
            this.east = west.func_197751_a(0.875, 0.0, 0.0);
        }

        public boolean isTank() {
            return this.tank;
        }

        public boolean isChannel() {
            return this.tank;
        }

        public VoxelShape getShape(Direction direction) {
            switch (direction) {
                case NORTH: {
                    return this.north;
                }
                case SOUTH: {
                    return this.south;
                }
                case EAST: {
                    return this.east;
                }
                case WEST: {
                    return this.west;
                }
            }
            return VoxelShapes.func_197880_a();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

