/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.capability.CapabilityGreenHouseData;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.world.GreenHouse;
import com.infinityraider.agricraft.util.GreenHouseHelper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GreenHouseHandler {
    private static final GreenHouseHandler INSTANCE = new GreenHouseHandler();

    public static GreenHouseHandler getInstance() {
        return INSTANCE;
    }

    private GreenHouseHandler() {
    }

    public void checkAndFormGreenHouse(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().isAir(state, (IBlockReader)world, pos)) {
            return;
        }
        new GreenHouseFormer(world, pos).getGreenHouse().ifPresent(greenHouse -> {
            if (greenHouse.isValid()) {
                CapabilityGreenHouseData.getInstance().addGreenHouse(world, (GreenHouse)greenHouse);
                greenHouse.convertAirBlocks(world);
            }
        });
    }

    public static class GreenHouseFormer {
        private final World world;
        private final Set<BlockPos> toVisit;
        private final Map<BlockPos, GreenHouse.BlockType> visited;
        private int interiorCount;
        private boolean valid;
        private GreenHouse greenHouse;

        protected GreenHouseFormer(World world, BlockPos start) {
            this.world = world;
            this.toVisit = Sets.newConcurrentHashSet();
            this.visited = Maps.newHashMap();
            this.toVisit.add(start);
            this.valid = true;
        }

        public Optional<GreenHouse> getGreenHouse() {
            if (this.greenHouse == null) {
                this.run();
            }
            return Optional.ofNullable(this.greenHouse);
        }

        public World getWorld() {
            return this.world;
        }

        public boolean isValid() {
            return this.valid;
        }

        public int getBlockLimit() {
            return ((Config)AgriCraft.instance.getConfig()).getGreenHouseBlockSizeLimit();
        }

        public boolean canContinue() {
            return this.interiorCount < this.getBlockLimit() && this.isValid();
        }

        public boolean hasVisited(BlockPos pos) {
            return this.visited.containsKey(pos);
        }

        public void recordVisit(BlockPos pos, GreenHouse.BlockType type) {
            this.visited.put(pos, type);
        }

        protected void run() {
            Iterator<BlockPos> iterator = this.toVisit.iterator();
            while (iterator.hasNext() && this.canContinue()) {
                BlockPos pos = iterator.next();
                iterator.remove();
                this.checkPosition(pos);
            }
            if (this.toVisit.isEmpty()) {
                if (this.isValid()) {
                    this.greenHouse = new GreenHouse(this.visited);
                }
            } else if (this.canContinue()) {
                this.run();
            } else {
                this.valid = false;
            }
        }

        protected void checkPosition(BlockPos pos) {
            if (!this.hasVisited(pos)) {
                BlockState state = this.getWorld().func_180495_p(pos);
                if (state.func_177230_c().isAir(state, (IBlockReader)this.getWorld(), pos)) {
                    this.recordVisit(pos, GreenHouse.BlockType.INTERIOR_AIR);
                } else {
                    this.valid = false;
                }
            }
            Arrays.stream(Direction.values()).forEach(dir -> {
                BlockPos checkPos = pos.func_177972_a(dir);
                BlockState state = this.getWorld().func_180495_p(checkPos);
                if (this.visited.containsKey(checkPos)) {
                    GreenHouse.BlockType type = this.visited.get(checkPos);
                    if (type.isBoundary() && !this.isSolidBlock(state, checkPos, (Direction)dir)) {
                        this.recordVisit(checkPos, GreenHouse.BlockType.INTERIOR_OTHER);
                        this.toVisit.add(checkPos);
                        ++this.interiorCount;
                    }
                } else if (this.isAirBlock(state, checkPos)) {
                    this.recordVisit(checkPos, GreenHouse.BlockType.INTERIOR_AIR);
                    this.toVisit.add(checkPos);
                    ++this.interiorCount;
                } else if (this.isGreenHouseGlass(state)) {
                    this.recordVisit(checkPos, GreenHouse.BlockType.GLASS);
                } else if (this.isSolidBlock(state, checkPos, (Direction)dir)) {
                    this.recordVisit(checkPos, GreenHouse.BlockType.BOUNDARY);
                } else {
                    this.recordVisit(checkPos, GreenHouse.BlockType.INTERIOR_OTHER);
                    this.toVisit.add(checkPos);
                    ++this.interiorCount;
                }
            });
        }

        protected boolean isAirBlock(BlockState state, BlockPos pos) {
            return state.func_177230_c().isAir(state, (IBlockReader)this.getWorld(), pos);
        }

        protected boolean isSolidBlock(BlockState state, BlockPos pos, Direction dir) {
            return state.func_224755_d((IBlockReader)this.getWorld(), pos, dir) || state.func_224755_d((IBlockReader)this.getWorld(), pos, dir.func_176734_d());
        }

        protected boolean isGreenHouseGlass(BlockState state) {
            return GreenHouseHelper.isGreenHouseGlass(state);
        }
    }
}

