/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedBagItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriTrowelItem;
import com.infinityraider.agricraft.capability.CapabilityGeneInspector;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.tools.ItemSeedBag;
import com.infinityraider.agricraft.reference.AgriToolTips;
import com.infinityraider.infinitylib.modules.keyboard.ModuleKeyboard;
import java.text.MessageFormat;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ItemToolTipHandler {
    private static final ItemToolTipHandler INSTANCE = new ItemToolTipHandler();

    public static ItemToolTipHandler getInstance() {
        return INSTANCE;
    }

    private ItemToolTipHandler() {
    }

    private static void addFormatted(ItemTooltipEvent event, String format, Object ... objects) {
        event.getToolTip().add(new StringTextComponent(MessageFormat.format(format, objects)).func_240699_a_(TextFormatting.DARK_AQUA));
    }

    private static void addCategory(ItemTooltipEvent event, String category) {
        event.getToolTip().add(new StringTextComponent(category + ":").func_240699_a_(TextFormatting.DARK_AQUA));
    }

    private static void addParameter(ItemTooltipEvent event, String key, Object value) {
        event.getToolTip().add(new StringTextComponent(" - " + key + ": " + value).func_240699_a_(TextFormatting.DARK_AQUA));
    }

    @SubscribeEvent
    public void addRegistryInfo(ItemTooltipEvent event) {
        if (((Config)AgriCraft.instance.getConfig()).registryTooltips()) {
            Item item = event.getItemStack().func_77973_b();
            ItemToolTipHandler.addCategory(event, "Registry");
            ItemToolTipHandler.addParameter(event, "id", item.getRegistryName());
        }
    }

    @SubscribeEvent
    public void addNbtInfo(ItemTooltipEvent event) {
        if (((Config)AgriCraft.instance.getConfig()).nbtTooltips()) {
            ItemToolTipHandler.addCategory(event, "NBT");
            if (event.getItemStack().func_77942_o()) {
                CompoundNBT tag = event.getItemStack().func_77978_p();
                for (String key : tag.func_150296_c()) {
                    ItemToolTipHandler.addParameter(event, key, tag.func_74781_a(key));
                }
            } else {
                ItemToolTipHandler.addFormatted(event, " - No NBT Data", new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public void addTagInfo(ItemTooltipEvent event) {
        if (((Config)AgriCraft.instance.getConfig()).tagTooltips()) {
            ItemToolTipHandler.addCategory(event, "Item Tags");
            Collection itemTags = ItemTags.func_199903_a().func_199913_a((Object)event.getItemStack().func_77973_b());
            if (itemTags.size() > 0) {
                itemTags.forEach(tag -> ItemToolTipHandler.addFormatted(event, " - " + tag.toString(), new Object[0]));
            } else {
                ItemToolTipHandler.addFormatted(event, " - No Item Tags", new Object[0]);
            }
            if (event.getItemStack().func_77973_b() instanceof BlockItem) {
                ItemToolTipHandler.addCategory(event, "Block Tags");
                Collection blockTags = BlockTags.func_199896_a().func_199913_a((Object)((BlockItem)event.getItemStack().func_77973_b()).func_179223_d());
                if (blockTags.size() > 0) {
                    blockTags.forEach(tag -> ItemToolTipHandler.addFormatted(event, " - " + tag.toString(), new Object[0]));
                } else {
                    ItemToolTipHandler.addFormatted(event, " - No Block Tags", new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public void addSoilInfo(ItemTooltipEvent event) {
        AgriApi.getSoilRegistry().valueOf(event.getItemStack()).ifPresent(soil -> soil.addDisplayInfo(text -> event.getToolTip().add(text)));
    }

    @SubscribeEvent
    public void addJournalTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IAgriJournalItem) {
            IAgriJournalItem journal = (IAgriJournalItem)stack.func_77973_b();
            int count = journal.getDiscoveredSeeds(stack).size();
            event.getToolTip().add(new StringTextComponent("" + count + " ").func_230529_a_(AgriToolTips.JOURNAL_SEEDS));
            event.getToolTip().add(AgriToolTips.JOURNAL_USE_1);
            event.getToolTip().add(AgriToolTips.JOURNAL_USE_2);
        }
    }

    @SubscribeEvent
    public void addTrowelTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IAgriTrowelItem) {
            event.getToolTip().add(AgriToolTips.TROWEL);
            IAgriTrowelItem trowel = (IAgriTrowelItem)stack.func_77973_b();
            trowel.getGenome(stack).map(genome -> {
                event.getToolTip().add(AgriToolTips.getPlantTooltip(genome.getPlant()));
                trowel.getGrowthStage(stack).ifPresent(stage -> event.getToolTip().add(AgriToolTips.getGrowthTooltip(stage)));
                return genome.getStats();
            }).ifPresent(stats -> stats.addTooltips(text -> event.getToolTip().add(text)));
        }
    }

    @SubscribeEvent
    public void addClipperTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof IAgriClipperItem) {
            event.getToolTip().add(AgriToolTips.CLIPPER);
        }
    }

    @SubscribeEvent
    public void addRakeTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof IAgriRakeItem) {
            event.getToolTip().add(AgriToolTips.RAKE);
        }
    }

    @SubscribeEvent
    public void addSeedBagTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ItemSeedBag) {
            ItemSeedBag bag = (ItemSeedBag)stack.func_77973_b();
            IAgriSeedBagItem.Contents contents = bag.getContents(stack);
            if (bag.isActivated(stack)) {
                if (event.getToolTip().size() > 0) {
                    ITextComponent name = (ITextComponent)event.getToolTip().get(0);
                    event.getToolTip().clear();
                    event.getToolTip().add(name);
                }
                event.getToolTip().add(AgriToolTips.SEED_BAG_ACTIVE);
                event.getToolTip().add(AgriToolTips.EMPTY_LINE);
                if (contents.getPlant().isPlant()) {
                    event.getToolTip().add(new StringTextComponent("").func_230529_a_(AgriToolTips.SEED_BAG_CONTENTS).func_230529_a_((ITextComponent)new StringTextComponent(" " + contents.getCount() + " ")).func_230529_a_((ITextComponent)contents.getPlant().getSeedName()));
                } else {
                    event.getToolTip().add(AgriToolTips.SEED_BAG_EMPTY);
                }
                event.getToolTip().add(new StringTextComponent("").func_230529_a_(AgriToolTips.SEED_BAG_SORTER).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_(contents.getSorter().getName()));
                event.getToolTip().add(AgriToolTips.EMPTY_LINE);
                if (ModuleKeyboard.getInstance().isKeyPressed(Minecraft.func_71410_x().field_71474_y.field_228046_af_)) {
                    event.getToolTip().add(new StringTextComponent("").func_240699_a_(TextFormatting.DARK_GRAY).func_230529_a_(AgriToolTips.SEED_BAG_MAIN_HAND));
                    event.getToolTip().add(new StringTextComponent("").func_240699_a_(TextFormatting.DARK_GRAY).func_230529_a_(AgriToolTips.SEED_BAG_OFF_HAND));
                    event.getToolTip().add(new StringTextComponent("").func_240699_a_(TextFormatting.DARK_GRAY).func_230529_a_(AgriToolTips.SEED_BAG_SCROLLING));
                } else {
                    event.getToolTip().add(new StringTextComponent("").func_240699_a_(TextFormatting.DARK_GRAY).func_230529_a_(AgriToolTips.SNEAK_INFO));
                }
            } else {
                event.getToolTip().add(AgriToolTips.SEED_BAG_INACTIVE_1);
                event.getToolTip().add(AgriToolTips.SEED_BAG_INACTIVE_2);
            }
        }
    }

    @SubscribeEvent
    public void addHelmetTooltip(ItemTooltipEvent event) {
        if (CapabilityGeneInspector.getInstance().hasInspectionCapability(event.getItemStack())) {
            event.getToolTip().add(AgriToolTips.GENE_INSPECTOR);
        }
    }
}

