/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.requirement;

import com.google.common.collect.Sets;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowCondition;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.handler.BlockUpdateHandler;
import com.infinityraider.agricraft.reference.AgriToolTips;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class RequirementCache {
    private static final RequirementCache EMPTY = new RequirementCache(){

        @Override
        public IAgriGrowthResponse check() {
            return IAgriGrowthResponse.INFERTILE;
        }

        @Override
        public void addTooltip(Consumer<ITextComponent> consumer) {
            consumer.accept((ITextComponent)AgriToolTips.UNKNOWN);
        }
    };

    public static RequirementCache create(IAgriCrop crop) {
        if (crop.hasPlant()) {
            return new Impl(crop);
        }
        return EMPTY;
    }

    public abstract IAgriGrowthResponse check();

    public abstract void addTooltip(Consumer<ITextComponent> var1);

    public void flush() {
    }

    private static class Impl
    extends RequirementCache {
        private final List<Condition> conditions;

        private Impl(IAgriCrop crop) {
            this.conditions = crop.getPlant().getGrowthRequirement(crop.getGrowthStage()).getGrowConditions().stream().sorted(Comparator.comparingInt(IAgriGrowCondition::getComplexity)).map(condition -> Condition.create(crop, condition, crop.getStats().getStrength())).collect(Collectors.toList());
        }

        @Override
        public IAgriGrowthResponse check() {
            return this.conditions.stream().map(Condition::check).collect(IAgriGrowthResponse.COLLECTOR);
        }

        @Override
        public void addTooltip(Consumer<ITextComponent> consumer) {
            IAgriGrowthResponse response = this.check();
            if (response.isFertile()) {
                consumer.accept(AgriToolTips.FERTILE);
            } else {
                consumer.accept(AgriToolTips.NOT_FERTILE);
                this.conditions.stream().filter(condition -> !condition.check().isFertile()).forEach(condition -> condition.addTooltip(consumer));
            }
        }

        @Override
        public void flush() {
            this.conditions.forEach(Condition::flush);
        }

        private static class Condition {
            private final IAgriCrop crop;
            private final IAgriGrowCondition condition;
            private final int strength;

            private static Condition create(IAgriCrop crop, IAgriGrowCondition condition, int strength) {
                switch (condition.getCacheType()) {
                    case NONE: {
                        return new Condition(crop, condition, strength);
                    }
                    case BLOCK_UPDATE: {
                        return new BlockUpdateCache(crop, condition, strength);
                    }
                    case FULL: {
                        return new FullCache(crop, condition, strength);
                    }
                }
                return new Condition(crop, condition, strength);
            }

            private Condition(IAgriCrop crop, IAgriGrowCondition condition, int strength) {
                this.crop = crop;
                this.condition = condition;
                this.strength = strength;
            }

            public IAgriGrowthResponse check() {
                if (this.getWorld() == null) {
                    return IAgriGrowthResponse.INFERTILE;
                }
                return this.getCondition().check(this.getWorld(), this.getPos(), this.getStrength());
            }

            public void addTooltip(Consumer<ITextComponent> consumer) {
                this.getCondition().notMetDescription(tooltip -> consumer.accept((ITextComponent)new StringTextComponent(" - ").func_230529_a_(tooltip)));
            }

            public void flush() {
            }

            protected IAgriCrop getCrop() {
                return this.crop;
            }

            @Nullable
            protected World getWorld() {
                return this.getCrop().world();
            }

            protected BlockPos getPos() {
                return this.getCrop().getPosition();
            }

            protected IAgriGrowCondition getCondition() {
                return this.condition;
            }

            protected int getStrength() {
                return this.strength;
            }

            private static class FullCache
            extends Condition {
                private IAgriGrowthResponse status = IAgriGrowthResponse.INFERTILE;
                private boolean update = true;

                private FullCache(IAgriCrop crop, IAgriGrowCondition condition, int strength) {
                    super(crop, condition, strength);
                }

                @Override
                public IAgriGrowthResponse check() {
                    if (this.getWorld() == null) {
                        return this.status;
                    }
                    if (this.update) {
                        this.status = super.check();
                        this.update = false;
                    }
                    return this.status;
                }
            }

            private static class BlockUpdateCache
            extends Condition
            implements BlockUpdateHandler.IListener {
                private IAgriGrowthResponse status = IAgriGrowthResponse.INFERTILE;
                private boolean update = true;
                private final Set<BlockPos> unloadedPositions = Sets.newHashSet();

                private BlockUpdateCache(IAgriCrop crop, IAgriGrowCondition condition, int strength) {
                    super(crop, condition, strength);
                    this.getCondition().offsetsToCheck().forEach(offset -> this.unloadedPositions.add(this.getPos().func_177971_a((Vector3i)offset)));
                }

                @Override
                public IAgriGrowthResponse check() {
                    if (this.getWorld() == null) {
                        return this.status;
                    }
                    this.checkUnloaded();
                    if (this.update) {
                        this.status = super.check();
                        this.update = false;
                    }
                    return this.status;
                }

                protected void checkUnloaded() {
                    if (this.getWorld() == null) {
                        return;
                    }
                    this.unloadedPositions.removeIf(pos -> {
                        if (this.getWorld().isAreaLoaded(pos, 1)) {
                            BlockUpdateHandler.getInstance().addListener(this.getWorld(), (BlockPos)pos, this);
                            return true;
                        }
                        return false;
                    });
                }

                @Override
                public void flush() {
                    this.getCondition().offsetsToCheck().forEach(pos -> BlockUpdateHandler.getInstance().removeListener(this.getWorld(), this.getPos().func_177971_a((Vector3i)pos), this));
                }

                @Override
                public void onBlockUpdate(ServerWorld world, BlockPos pos) {
                    this.update = true;
                }

                @Override
                public void onChunkUnloaded(ServerWorld world, BlockPos pos) {
                    this.unloadedPositions.add(pos);
                }

                @Override
                public void onWorldUnloaded(ServerWorld world, BlockPos pos) {
                }
            }
        }
    }
}

