/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.immersiveengineering;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.plant.AgriPlantIngredient;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.AnySoilIngredient;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.impl.v1.requirement.NoSoil;
import com.infinityraider.agricraft.impl.v1.stats.NoStats;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import com.infinityraider.infinitylib.crafting.IInfRecipeSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableObject;

public class AgriClocheRecipe
extends ClocheRecipe {
    private static final ItemStack FARMLAND = new ItemStack((IItemProvider)Items.field_221736_cd);
    public static final Serializer SERIALIZER = new Serializer();
    private static final List<ItemStack> SEED_STACK = ImmutableList.of((Object)new ItemStack((IItemProvider)AgriCraft.instance.getModItemRegistry().seed));
    private static final Random RANDOM = new Random();
    private static final ClocheRenderFunction.ClocheRenderReference RENDER_REFERENCE = new ClocheRenderFunction.ClocheRenderReference(AgriCraft.instance.getModId(), (Block)AgriCraft.instance.getModBlockRegistry().crop_plant);
    private final AgriPlantIngredient seed;
    private final float growthStatFactor;

    public AgriClocheRecipe(ResourceLocation id, AgriPlantIngredient seed, int time, float growthStatFactor) {
        super(id, SEED_STACK, (Ingredient)seed, (Ingredient)AnySoilIngredient.getInstance(), time, RENDER_REFERENCE);
        this.seed = seed;
        this.growthStatFactor = growthStatFactor;
    }

    public AgriPlantIngredient getSeed() {
        return this.seed;
    }

    public int getGrowthTicks() {
        return this.time;
    }

    public float getGrowthStatFactor() {
        return this.growthStatFactor;
    }

    protected IAgriPlant getPlant(ItemStack seed) {
        if (seed.func_77973_b() instanceof IAgriSeedItem) {
            return ((IAgriSeedItem)seed.func_77973_b()).getPlant(seed);
        }
        return NoPlant.getInstance();
    }

    protected Optional<IAgriStatsMap> getStats(ItemStack seed) {
        if (seed.func_77973_b() instanceof IAgriSeedItem) {
            return ((IAgriSeedItem)seed.func_77973_b()).getStats(seed);
        }
        return Optional.empty();
    }

    protected IAgriSoil getSoil(ItemStack soil) {
        if (soil.func_77973_b() == Items.field_221582_j) {
            return AgriApi.getSoilRegistry().valueOf(Blocks.field_150458_ak).orElse(NoSoil.getInstance());
        }
        return AgriApi.getSoilRegistry().valueOf(soil).orElse(NoSoil.getInstance());
    }

    public boolean matches(ItemStack seed, ItemStack soil) {
        return ((ClocheRecipe)this).seed.test(seed) && (this.soil.test(soil) || this.soil.test(this.transformSoil(soil)));
    }

    protected ItemStack transformSoil(ItemStack soil) {
        if (soil.func_190926_b()) {
            return soil;
        }
        if (soil.func_77973_b() == Items.field_221582_j) {
            return FARMLAND;
        }
        return soil;
    }

    public List<ItemStack> getOutputs(ItemStack seed, ItemStack soil) {
        ArrayList outputs = Lists.newArrayList();
        IAgriPlant plant = this.getPlant(seed);
        if (plant.isPlant()) {
            this.getPlant(seed).getHarvestProducts(outputs::add, plant.getFinalStage(), this.getStats(seed).orElse(NoStats.getInstance()), RANDOM);
        }
        return outputs;
    }

    public int getTime(ItemStack seed, ItemStack soilStack) {
        IAgriPlant plant = this.getPlant(seed);
        IAgriSoil soil = this.getSoil(soilStack);
        Optional<IAgriStatsMap> statsOptional = this.getStats(seed);
        if (plant.isPlant() && soil.isSoil() && statsOptional.isPresent()) {
            IAgriStatsMap stats = statsOptional.get();
            IAgriGrowthRequirement req = plant.getGrowthRequirement(plant.getInitialGrowthStage());
            int strength = stats.getStrength();
            if (!req.getSoilHumidityResponse(soil.getHumidity(), strength).isFertile()) {
                return Integer.MAX_VALUE;
            }
            if (!req.getSoilAcidityResponse(soil.getAcidity(), strength).isFertile()) {
                return Integer.MAX_VALUE;
            }
            if (!req.getSoilNutrientsResponse(soil.getNutrients(), strength).isFertile()) {
                return Integer.MAX_VALUE;
            }
            double growthFactor = 1.0f - (float)stats.getGrowth() * this.getGrowthStatFactor();
            double soilFactor = 2.0 - soil.getGrowthModifier();
            return Math.max((int)((double)this.getGrowthTicks() * growthFactor * soilFactor), 1);
        }
        return Integer.MAX_VALUE;
    }

    public ItemStack func_77571_b() {
        MutableObject product = new MutableObject();
        this.getSeed().getPlant().getAllPossibleProducts(stack -> {
            if (product.getValue() == null) {
                product.setValue(stack);
            }
        });
        ItemStack result = (ItemStack)product.getValue();
        return result == null ? ItemStack.field_190927_a : result;
    }

    protected IERecipeSerializer<ClocheRecipe> getIESerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    extends IERecipeSerializer<ClocheRecipe>
    implements IRecipeSerializer<ClocheRecipe>,
    IInfRecipeSerializer {
        private static final String ID = "agri_cloche_recipe";

        private Serializer() {
        }

        @Nonnull
        public String getInternalName() {
            return ID;
        }

        public boolean isEnabled() {
            return true;
        }

        public Collection<IInfIngredientSerializer<?>> getIngredientSerializers() {
            return Collections.emptyList();
        }

        public ItemStack getIcon() {
            return new ItemStack((IItemProvider)AgriCraft.instance.getModItemRegistry().debugger);
        }

        public AgriClocheRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            if (!json.has("plant")) {
                throw new JsonParseException("Agricraft botany pots crop must have a \"plant\" property");
            }
            if (!json.has("growthTicks")) {
                throw new JsonParseException("Agricraft botany pots crop must have a \"growthTicks\" property");
            }
            if (!json.has("growthStatFactor")) {
                throw new JsonParseException("Agricraft botany pots crop must have a \"growthStatFactor\" property");
            }
            AgriPlantIngredient plant = (AgriPlantIngredient)AgriCraft.instance.getModRecipeSerializerRegistry().plant_ingredient.parse(json);
            int growthTicks = json.get("growthTicks").getAsInt();
            float growthStatFactor = json.get("growthStatFactor").getAsFloat();
            Map RENDER_FUNCTION_FACTORIES = ClocheRenderFunction.RENDER_FUNCTION_FACTORIES;
            return new AgriClocheRecipe(recipeId, plant, growthTicks, growthStatFactor);
        }

        @Nullable
        public AgriClocheRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            if (buffer.readBoolean()) {
                AgriPlantIngredient plant = (AgriPlantIngredient)AgriCraft.instance.getModRecipeSerializerRegistry().plant_ingredient.parse(buffer);
                int growthTicks = buffer.readInt();
                float growthStatFactor = buffer.readFloat();
                return new AgriClocheRecipe(recipeId, plant, growthTicks, growthStatFactor);
            }
            return null;
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull ClocheRecipe clocheRecipe) {
            if (clocheRecipe instanceof AgriClocheRecipe) {
                AgriClocheRecipe recipe = (AgriClocheRecipe)clocheRecipe;
                buffer.writeBoolean(true);
                AgriCraft.instance.getModRecipeSerializerRegistry().plant_ingredient.write(buffer, (Ingredient)recipe.getSeed());
                buffer.writeInt(recipe.getGrowthTicks());
                buffer.writeFloat(recipe.getGrowthStatFactor());
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

