/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.client.IJournalDataDrawer;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.impl.v1.journal.GrowthReqsPage;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JournalDataDrawerGrowthReqs
extends JournalDataDrawerBase<GrowthReqsPage> {
    private final ITextComponent GROWTH_REQS = new TranslationTextComponent("agricraft.journal.growth_reqs");
    private final ITextComponent PARAGRAPH_L_1 = new TranslationTextComponent("agricraft.journal.growth_reqs.paragraph_1");
    private final ITextComponent BRIGHTNESS = new TranslationTextComponent("agricraft.journal.growth_reqs.brightness");
    private final ITextComponent PARAGRAPH_BRIGHTNESS = new TranslationTextComponent("agricraft.journal.growth_reqs.brightness.desc");
    private final ITextComponent HUMIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.humidity");
    private final ITextComponent PARAGRAPH_HUMIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.humidity.desc");
    private final ITextComponent ACIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.acidity");
    private final ITextComponent PARAGRAPH_ACIDITY = new TranslationTextComponent("agricraft.journal.growth_reqs.acidity.desc");
    private final ITextComponent NUTRIENTS = new TranslationTextComponent("agricraft.journal.growth_reqs.nutrients");
    private final ITextComponent PARAGRAPH_NUTRIENTS = new TranslationTextComponent("agricraft.journal.growth_reqs.nutrients.desc");
    private final ITextComponent SEASONS = new TranslationTextComponent("agricraft.journal.growth_reqs.seasons");
    private final ITextComponent PARAGRAPH_SEASONS = new TranslationTextComponent("agricraft.journal.growth_reqs.seasons.desc");

    @Override
    public ResourceLocation getId() {
        return GrowthReqsPage.INSTANCE.getDataDrawerId();
    }

    @Override
    public void drawLeftSheet(GrowthReqsPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        float dy = 10.0f;
        float dx = 6.0f;
        float spacing = 4.0f;
        dy += context.drawText(transforms, this.GROWTH_REQS, dx, dy);
        dy += spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_L_1, dx, dy, 0.65f);
        dy += spacing;
        dy += context.drawText(transforms, this.BRIGHTNESS, dx, dy, 0.65f);
        context.draw(transforms, JournalDataDrawerBase.Textures.BRIGHTNESS_BAR, 6.0f, dy, 66.0f, 8.0f);
        dy += 6.0f + spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_BRIGHTNESS, dx, dy, 0.5f);
        dy += spacing;
        dy += context.drawText(transforms, this.HUMIDITY, dx, dy, 0.65f);
        dy += context.drawText(transforms, this.PARAGRAPH_HUMIDITY, dx, dy, 0.5f);
        this.drawSoilProperties(context, transforms, dx, dy, spacing, IAgriSoil.Humidity.values(), JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS, JournalDataDrawerBase.Textures.HUMIDITY_FILLED);
    }

    @Override
    public void drawRightSheet(GrowthReqsPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        float dy = 10.0f;
        float dx = 6.0f;
        float spacing = 4.0f;
        dy += context.drawText(transforms, this.ACIDITY, dx, dy, 0.65f);
        dy += context.drawText(transforms, this.PARAGRAPH_ACIDITY, dx, dy, 0.5f);
        dy = this.drawSoilProperties(context, transforms, dx, dy, spacing, IAgriSoil.Acidity.values(), JournalDataDrawerBase.Textures.ACIDITY_OFFSETS, JournalDataDrawerBase.Textures.ACIDITY_FILLED);
        dy += context.drawText(transforms, this.NUTRIENTS, dx, dy, 0.65f);
        dy += context.drawText(transforms, this.PARAGRAPH_NUTRIENTS, dx, dy, 0.5f);
        dy = this.drawSoilProperties(context, transforms, dx, dy, spacing, IAgriSoil.Nutrients.values(), JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS, JournalDataDrawerBase.Textures.NUTRIENTS_FILLED);
        if (AgriApi.getSeasonLogic().isActive()) {
            dy += context.drawText(transforms, this.SEASONS, dx, dy, 0.65f);
            dy += context.drawText(transforms, this.PARAGRAPH_SEASONS, dx, dy, 0.5f);
            float scale = 0.5f;
            dy += spacing * scale;
            for (int i = 0; i < AgriSeason.values().length - 1; ++i) {
                int w = 10;
                int h = 12;
                float v1 = (0.0f + (float)(i * h)) / 48.0f;
                float v2 = (0.0f + (float)((i + 1) * h)) / 48.0f;
                context.draw(transforms, JournalDataDrawerBase.Textures.SEASONS_FILLED, dx, dy - spacing / 2.0f, scale * (float)w, scale * (float)h, 0.0f, v1, 1.0f, v2);
                dy += context.drawText(transforms, (ITextComponent)AgriSeason.values()[i].getDisplayName(), dx + 6.0f, dy, 0.5f);
                dy += spacing / 2.0f;
            }
        }
    }

    protected float drawSoilProperties(IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, float dx, float dy, float spacing, IAgriSoil.SoilProperty[] property, int[] offsets, ResourceLocation texture) {
        float scale = 0.5f;
        dy += spacing * scale;
        for (int i = 0; i < property.length - 1; ++i) {
            int w = offsets[i + 1] - offsets[i];
            float u1 = ((float)offsets[i] + 0.0f) / 53.0f;
            float u2 = ((float)(offsets[i] + w) + 0.0f) / 53.0f;
            context.draw(transforms, texture, dx, dy - spacing / 2.0f, scale * (float)w, scale * 12.0f, u1, 0.0f, u2, 1.0f);
            dy += context.drawText(transforms, property[i].getDescription(), dx + 6.0f, dy, 0.5f);
            dy += spacing / 2.0f;
        }
        return dy + spacing;
    }
}

