/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.client.IJournalDataDrawer;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.impl.v1.journal.PlantPage;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JournalDataDrawerPlant
extends JournalDataDrawerBase<PlantPage> {
    private static final ITextComponent GROWTH_STAGES = new TranslationTextComponent("agricraft.tooltip.growth_stages");
    private static final ITextComponent GROWTH_REQUIREMENTS = new TranslationTextComponent("agricraft.tooltip.growth_requirements");
    private static final ITextComponent PRODUCTS = new TranslationTextComponent("agricraft.tooltip.products");
    private static final ITextComponent MUTATIONS = new TranslationTextComponent("agricraft.tooltip.mutations");

    @Override
    public ResourceLocation getId() {
        return PlantPage.ID;
    }

    @Override
    public void drawLeftSheet(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        context.draw(transforms, JournalDataDrawerBase.Textures.TITLE, 0.0f, 2.0f, 128.0f, 20.0f);
        context.drawText(transforms, (ITextComponent)page.getPlant().getSeedName(), 30.0f, 10.0f);
        float offset = 0.0f;
        if (!page.getPlant().getInformation().getString().isEmpty()) {
            offset = context.drawText(transforms, (ITextComponent)page.getPlant().getInformation(), 10.0f, 30.0f, 0.7f);
        }
        this.drawGrowthRequirements(page, context, transforms, 35.0f + offset);
        page.getPlant().getGuiRenderer().drawSeed(page.getPlant(), context, transforms, 4.0f, 5.0f, 16.0f, 16.0f);
        this.drawGrowthStages(page, context, transforms);
    }

    @Override
    public void drawRightSheet(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        this.drawProducts(page, context, transforms);
        this.drawMutations(page, context, transforms);
    }

    protected void drawGrowthRequirements(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, float offset) {
        int w;
        int dx;
        int i;
        float dy = Math.max(offset, 60.0f);
        dy += context.drawText(transforms, GROWTH_REQUIREMENTS, 10.0f, dy, 0.8f) + 1.0f;
        context.draw(transforms, JournalDataDrawerBase.Textures.BRIGHTNESS_BAR, 6.0f, dy, 66.0f, 8.0f);
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.0, 0.0, (double)-0.001f);
        for (i = 0; i < page.brightnessMask().length; ++i) {
            boolean current = page.brightnessMask()[i];
            if (!current) continue;
            boolean prev = i > 0 && page.brightnessMask()[i - 1];
            boolean next = i < page.brightnessMask().length - 1 && page.brightnessMask()[i + 1];
            context.draw(transforms, JournalDataDrawerBase.Textures.BRIGHTNESS_HIGHLIGHT, (float)(6 + 4 * i + 1), dy, 4.0f, 8.0f, 0.25f, 0.0f, 0.75f, 1.0f);
            if (!prev) {
                context.draw(transforms, JournalDataDrawerBase.Textures.BRIGHTNESS_HIGHLIGHT, (float)(6 + 4 * i), dy, 1.0f, 8.0f, 0.0f, 0.0f, 0.25f, 1.0f);
            }
            if (next) continue;
            context.draw(transforms, JournalDataDrawerBase.Textures.BRIGHTNESS_HIGHLIGHT, (float)(6 + 4 * i + 5), dy, 1.0f, 8.0f, 0.75f, 0.0f, 1.0f, 1.0f);
        }
        dy += 9.0f;
        transforms.func_227865_b_();
        if (AgriApi.getSeasonLogic().isActive()) {
            for (i = 0; i < page.seasonMask().length; ++i) {
                dx = 70;
                w = 10;
                int h = 12;
                int x = i % 2 * (w + 2) + 5;
                int y = i / 2 * (h + 2) + 6;
                float v1 = (0.0f + (float)(i * h)) / 48.0f;
                float v2 = (0.0f + (float)((i + 1) * h)) / 48.0f;
                if (page.seasonMask()[i]) {
                    context.draw(transforms, JournalDataDrawerBase.Textures.SEASONS_FILLED, (float)(x + dx), (float)y + dy, (float)w, (float)h, 0.0f, v1, 1.0f, v2);
                    continue;
                }
                context.draw(transforms, JournalDataDrawerBase.Textures.SEASONS_EMPTY, (float)(x + dx), (float)y + dy, (float)w, (float)h, 0.0f, v1, 1.0f, v2);
            }
        }
        for (i = 0; i < page.humidityMask().length; ++i) {
            dx = JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS[i];
            w = JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS[i + 1] - JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS[i];
            float u1 = ((float)dx + 0.0f) / 53.0f;
            float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
            if (page.humidityMask()[i]) {
                context.draw(transforms, JournalDataDrawerBase.Textures.HUMIDITY_FILLED, (float)(10 + dx), dy, (float)w, 12.0f, u1, 0.0f, u2, 1.0f);
                continue;
            }
            context.draw(transforms, JournalDataDrawerBase.Textures.HUMIDITY_EMPTY, (float)(10 + dx), dy, (float)w, 12.0f, u1, 0.0f, u2, 1.0f);
        }
        dy += 13.0f;
        for (i = 0; i < page.acidityMask().length; ++i) {
            dx = JournalDataDrawerBase.Textures.ACIDITY_OFFSETS[i];
            w = JournalDataDrawerBase.Textures.ACIDITY_OFFSETS[i + 1] - JournalDataDrawerBase.Textures.ACIDITY_OFFSETS[i];
            float u1 = ((float)dx + 0.0f) / 53.0f;
            float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
            if (page.acidityMask()[i]) {
                context.draw(transforms, JournalDataDrawerBase.Textures.ACIDITY_FILLED, (float)(10 + dx), dy, (float)w, 12.0f, u1, 0.0f, u2, 1.0f);
                continue;
            }
            context.draw(transforms, JournalDataDrawerBase.Textures.ACIDITY_EMPTY, (float)(10 + dx), dy, (float)w, 12.0f, u1, 0.0f, u2, 1.0f);
        }
        dy += 13.0f;
        for (i = 0; i < page.nutrientsMask().length; ++i) {
            dx = JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS[i];
            w = JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS[i + 1] - JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS[i];
            float u1 = ((float)dx + 0.0f) / 53.0f;
            float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
            if (page.nutrientsMask()[i]) {
                context.draw(transforms, JournalDataDrawerBase.Textures.NUTRIENTS_FILLED, (float)(10 + dx), dy, (float)w, 12.0f, u1, 0.0f, u2, 1.0f);
                continue;
            }
            context.draw(transforms, JournalDataDrawerBase.Textures.NUTRIENTS_EMPTY, (float)(10 + dx), dy, (float)w, 12.0f, u1, 0.0f, u2, 1.0f);
        }
    }

    protected void drawGrowthStages(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms) {
        int y0 = 170;
        int delta = 20;
        int rows = page.getStages().size() / 6 + (page.getStages().size() % 6 > 0 ? 1 : 0);
        int columns = page.getStages().size() / rows + (page.getStages().size() % rows > 0 ? 1 : 0);
        int row = 0;
        int dx = (context.getPageWidth() - 16 * columns) / (columns + 1);
        for (int i = 0; i < page.getStages().size(); ++i) {
            int column = i % columns;
            if (i > 0 && column == 0) {
                ++row;
            }
            context.draw(transforms, JournalDataDrawerBase.Textures.GROWTH_STAGE, (float)(dx * (column + 1) + 16 * column - 1), (float)(y0 - delta * (rows - row - 1) - 1), 18.0f, 18.0f);
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.0, 0.0, (double)-0.001f);
            page.getPlant().getGuiRenderer().drawGrowthStage(page.getPlant(), page.getStages().get(i), context, transforms, dx * (column + 1) + 16 * column, y0 - delta * (rows - row - 1), 16.0f, 16.0f);
            transforms.func_227865_b_();
        }
        context.drawText(transforms, GROWTH_STAGES, 10.0f, y0 - delta * rows + 4, 0.9f);
    }

    protected void drawProducts(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms) {
        context.drawText(transforms, PRODUCTS, 10.0f, 10.0f, 0.8f);
        for (int i = 0; i < page.getDrops().size(); ++i) {
            context.draw(transforms, JournalDataDrawerBase.Textures.MUTATION, (float)(10 + i * 20), 19.0f, 18.0f, 18.0f, 0.0f, 0.0f, 0.20930232f, 1.0f);
            context.drawItem(transforms, page.getDrops().get(i), 11 + i * 20, 20.0f);
        }
    }

    protected void drawMutations(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms) {
        context.drawText(transforms, MUTATIONS, 10.0f, 45.0f, 0.8f);
        int posX = 10;
        int posY = 54;
        int dy = 20;
        for (List<IAgriPlant> plants : page.getOnPageMutations()) {
            this.drawMutation(context, transforms, posX, posY, plants);
            posY += dy;
        }
    }

    @Override
    public void drawTooltipLeft(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, int mouseX, int mouseY) {
        int w;
        int dx;
        int i;
        if (4 <= mouseX && mouseX <= 20 && 5 <= mouseY && mouseY <= 21) {
            context.drawTooltip(transforms, Collections.singletonList(page.getPlant().getTooltip()), mouseX, mouseY);
            return;
        }
        float offset = context.drawText(transforms, (ITextComponent)page.getPlant().getInformation(), -1000.0f, -1000.0f, 0.7f);
        float dy = Math.max(offset, 60.0f);
        dy += context.drawText(transforms, GROWTH_REQUIREMENTS, -1000.0f, -1000.0f, 0.8f) + 1.0f;
        for (i = 0; i < page.brightnessMask().length; ++i) {
            if (6 + 4 * i > mouseX || mouseX > 6 + 4 * i + 4 || !(dy + 1.0f <= (float)mouseY) || !((float)mouseY <= dy + 9.0f)) continue;
            context.drawTooltip(transforms, Collections.singletonList(new TranslationTextComponent("agricraft.tooltip.light").func_240702_b_(" " + i)), mouseX, mouseY);
            return;
        }
        dy += 9.0f;
        if (AgriApi.getSeasonLogic().isActive()) {
            for (i = 0; i < page.seasonMask().length; ++i) {
                int w2 = 10;
                int h = 12;
                int x = i % 2 * (w2 + 2) + 5 + 70;
                int y = i / 2 * (h + 2) + 6 + (int)dy;
                if (x > mouseX || mouseX > x + w2 || y > mouseY || mouseY > y + h) continue;
                context.drawTooltip(transforms, Collections.singletonList(AgriSeason.values()[i].getDisplayName()), mouseX, mouseY);
                return;
            }
        }
        for (i = 0; i < page.humidityMask().length; ++i) {
            dx = JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS[i] + 10;
            w = JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS[i + 1] - JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            context.drawTooltip(transforms, Collections.singletonList(IAgriSoil.Humidity.values()[i].getDescription()), mouseX, mouseY);
            return;
        }
        dy += 13.0f;
        for (i = 0; i < page.acidityMask().length; ++i) {
            dx = JournalDataDrawerBase.Textures.ACIDITY_OFFSETS[i] + 10;
            w = JournalDataDrawerBase.Textures.ACIDITY_OFFSETS[i + 1] - JournalDataDrawerBase.Textures.ACIDITY_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            context.drawTooltip(transforms, Collections.singletonList(IAgriSoil.Acidity.values()[i].getDescription()), mouseX, mouseY);
            return;
        }
        dy += 13.0f;
        for (i = 0; i < page.nutrientsMask().length; ++i) {
            dx = JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS[i] + 10;
            w = JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS[i + 1] - JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            context.drawTooltip(transforms, Collections.singletonList(IAgriSoil.Nutrients.values()[i].getDescription()), mouseX, mouseY);
            return;
        }
    }

    @Override
    public void drawTooltipRight(PlantPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, int x, int y) {
        for (int i = 0; i < page.getDrops().size(); ++i) {
            if (11 + i * 20 > x || x > 11 + i * 20 + 16 || 20 > y || y > 36) continue;
            context.drawTooltip(transforms, page.getDrops().get(i).func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), x, y);
        }
        int posX = 10;
        int posY = 54;
        int dy = 20;
        for (List<IAgriPlant> plants : page.getOnPageMutations()) {
            if (posX + 1 <= x && x <= posX + 17 && posY + 1 <= y && y <= posY + 17) {
                context.drawTooltip(transforms, Collections.singletonList(plants.get(0).getTooltip()), x, y);
            } else if (posX + 35 <= x && x <= posX + 51 && posY + 1 <= y && y <= posY + 17) {
                context.drawTooltip(transforms, Collections.singletonList(plants.get(1).getTooltip()), x, y);
            } else if (posX + 69 <= x && x <= posX + 85 && posY + 1 <= y && y <= posY + 17) {
                context.drawTooltip(transforms, Collections.singletonList(plants.get(2).getTooltip()), x, y);
            }
            posY += dy;
        }
    }
}

