/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import growthcraft.cellar.client.container.BrewKettleContainer;
import growthcraft.lib.util.ClientUtils;
import growthcraft.lib.util.TextureHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class BrewKettleScreen
extends ContainerScreen<BrewKettleContainer> {
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_cellar", "brew_kettle");

    public BrewKettleScreen(BrewKettleContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        matrixStack.func_227860_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        boolean baseX = false;
        boolean baseY = false;
        int maxX = 256;
        int maxY = 256;
        BrewKettleScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)((float)baseX), (float)((float)baseY), (int)this.field_146999_f, (int)this.field_147000_g, (int)maxX, (int)maxY);
        int guiProgressX = this.field_147003_i + 98;
        int guiProgressY = this.field_147009_r + 30;
        this.func_238474_b_(matrixStack, guiProgressX, guiProgressY, 176, 0, 9, ((BrewKettleContainer)this.field_147002_h).getSmeltProgressionScaled(28));
        int guiHeatLevelX = this.field_147003_i + 68;
        int guiHeatLevelY = this.field_147009_r + 53;
        if (((BrewKettleContainer)this.field_147002_h).isBurning()) {
            this.func_238474_b_(matrixStack, guiHeatLevelX, guiHeatLevelY, 176, 28, 13, 13);
        }
        int guiInputTankX = this.field_147003_i + 46;
        int guiInputTankY = this.field_147009_r + 17;
        int guiInputTankHeight = 52;
        if (((BrewKettleContainer)this.field_147002_h).getInputFluidTank().getFluidAmount() > 0) {
            FluidStack fluidStack = ((BrewKettleContainer)this.field_147002_h).getInputFluidTank().getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((BrewKettleContainer)this.field_147002_h).getInputFluidTank().getCapacity(), guiInputTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiInputTankX, guiInputTankY + (guiInputTankHeight - scaledFluidH), 16.0f, scaledFluidH);
        }
        int guiOutputTankX = this.field_147003_i + 114;
        int guiOutputTankY = this.field_147009_r + 17;
        int guiOutputTankHeight = 52;
        if (((BrewKettleContainer)this.field_147002_h).getOutputFluidTank().getFluidAmount() > 0) {
            FluidStack fluidStack = ((BrewKettleContainer)this.field_147002_h).getOutputFluidTank().getFluid();
            int scaledFluidH = this.getScaledFluid(fluidStack.getAmount(), ((BrewKettleContainer)this.field_147002_h).getInputFluidTank().getCapacity(), guiOutputTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiOutputTankX, guiOutputTankY + (guiOutputTankHeight - scaledFluidH), 16.0f, scaledFluidH);
        }
        renderTypeBuffer.func_228461_a_();
    }

    private int getScaledFluid(float amount, float capacity, int maxPixelSize) {
        float ratio = amount / capacity;
        float scaled = (float)maxPixelSize * ratio;
        return (int)scaled;
    }

    @ParametersAreNonnullByDefault
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), 8.0f, 6.0f, 0x404040);
    }

    @ParametersAreNonnullByDefault
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int guiInputTankX = this.field_147003_i + 46;
        int guiInputTankY = this.field_147009_r + 17;
        int guiInputTankHeight = 52;
        if (mouseX > guiInputTankX && mouseX < guiInputTankX + 16 && mouseY > guiInputTankY && mouseY < guiInputTankY + guiInputTankHeight) {
            FluidStack fluidStack = ((BrewKettleContainer)this.field_147002_h).getInputFluidTank().getFluid();
            String tooltip = String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount());
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        int guiOutputTankX = this.field_147003_i + 114;
        int guiOutputTankY = this.field_147009_r + 17;
        int guiOutputTankHeight = 52;
        if (mouseX > guiOutputTankX && mouseX < guiOutputTankX + 16 && mouseY > guiOutputTankY && mouseY < guiOutputTankY + guiOutputTankHeight) {
            FluidStack fluidStack = ((BrewKettleContainer)this.field_147002_h).getOutputFluidTank().getFluid();
            String tooltip = String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount());
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }
}

