/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block.crop;

import growthcraft.cellar.common.block.crop.GrapeCrop;
import growthcraft.cellar.common.block.crop.GrapeVineCrop;
import growthcraft.cellar.common.tileentity.GrapeVineTileEntity;
import growthcraft.cellar.init.GrowthcraftCellarBlocks;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.core.common.tileentity.RopeTileEntity;
import growthcraft.lib.common.block.GrowthcraftCropsRopeBlock;
import growthcraft.lib.util.BlockStateUtils;
import growthcraft.lib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GrapeVineLeavesCrop
extends GrowthcraftCropsRopeBlock {
    public static final BooleanProperty TRUNK_CONNECTED = BooleanProperty.func_177716_a((String)"trunk_connected");
    protected static final VoxelShape[] CUSTOM_SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public GrapeVineLeavesCrop() {
        super.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TRUNK_CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getActualBlockStateWithAge(World world, BlockPos blockPos, int age) {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(world, blockPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("north"))))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("east"))))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("south"))))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("west"))))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("up"))))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("down"))))).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age))).func_206870_a((Property)TRUNK_CONNECTED, (Comparable)Boolean.valueOf(blockMap.get("down").getBlock() instanceof GrapeVineCrop));
    }

    @Override
    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new Property[]{TRUNK_CONNECTED}));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftCellarTileEntities.grape_vine_tileentity.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public void grow(World worldIn, BlockPos pos, BlockState state) {
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn) + 1;
        if (i > this.getMaxAge()) {
            i = this.getMaxAge();
        }
        worldIn.func_180501_a(pos, this.getActualBlockStateWithAge(worldIn, pos, i), 2);
        if (i == this.getMaxAge()) {
            this.doMaxAge(worldIn, pos, state);
        }
    }

    @Override
    public void doMaxAge(World worldIn, BlockPos pos, BlockState state) {
        GrapeVineTileEntity grapeVineLeavesTileEntity = (GrapeVineTileEntity)worldIn.func_175625_s(pos);
        if (grapeVineLeavesTileEntity == null) {
            return;
        }
        Map<BlockPos, BlockState> blockMap = BlockStateUtils.getHorizontalBlockPos(worldIn, pos);
        for (Map.Entry<BlockPos, BlockState> blockEntry : blockMap.entrySet()) {
            RopeTileEntity ropeTileEntity;
            if (!BlockStateUtils.isRopeBlock(blockEntry.getValue().func_177230_c()) || !(worldIn.func_175625_s(blockEntry.getKey()) instanceof RopeTileEntity) || (ropeTileEntity = (RopeTileEntity)worldIn.func_175625_s(blockEntry.getKey())) == null || ropeTileEntity.hasFenceItemStack()) continue;
            worldIn.func_175656_a(blockEntry.getKey(), ((GrapeVineLeavesCrop)GrowthcraftCellarBlocks.GRAPE_VINE_LEAVES.get()).getActualBlockStateWithAge(worldIn, blockEntry.getKey(), 0));
            WorldUtils.notifyBlockUpdate(worldIn, blockEntry.getKey());
            GrapeVineTileEntity newGrapeVineLeavesTileEntity = (GrapeVineTileEntity)worldIn.func_175625_s(blockEntry.getKey());
            if (newGrapeVineLeavesTileEntity == null) continue;
            newGrapeVineLeavesTileEntity.setFruitItemStack(grapeVineLeavesTileEntity.getFruitItemStack());
        }
        if (worldIn.func_175623_d(pos.func_177977_b())) {
            worldIn.func_175656_a(pos.func_177977_b(), ((GrapeCrop)GrowthcraftCellarBlocks.GRAPE_VINE_CROP.get()).func_176223_P());
            GrapeVineTileEntity newGrapeVineCropTileEntity = (GrapeVineTileEntity)worldIn.func_175625_s(pos.func_177977_b());
            if (newGrapeVineCropTileEntity != null) {
                newGrapeVineCropTileEntity.setFruitItemStack(grapeVineLeavesTileEntity.getFruitItemStack());
            }
        }
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape ropeVoxel = super.func_220053_a(state, worldIn, pos, context);
        ArrayList<VoxelShape> voxelShapeArrayList = new ArrayList<VoxelShape>();
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(worldIn, pos);
        voxelShapeArrayList.add(CUSTOM_SHAPE_BY_AGE[0]);
        if (BlockStateUtils.isRopeBlock(blockMap.get("north"))) {
            voxelShapeArrayList.add(NORTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("east"))) {
            voxelShapeArrayList.add(EAST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("south"))) {
            voxelShapeArrayList.add(SOUTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("west"))) {
            voxelShapeArrayList.add(WEST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("up"))) {
            voxelShapeArrayList.add(UP_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("down"))) {
            voxelShapeArrayList.add(DOWN_BOUNDING_BOX);
        }
        voxelShapeArrayList.add(ropeVoxel);
        VoxelShape[] voxelShapes = new VoxelShape[voxelShapeArrayList.size()];
        voxelShapes = voxelShapeArrayList.toArray(voxelShapes);
        return VoxelShapes.func_216384_a((VoxelShape)KNOT_BOUNDING_BOX, (VoxelShape[])voxelShapes);
    }
}

