/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.recipe;

import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import java.util.Objects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RoasterRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation recipeId;
    private final ItemStack inputItemStack;
    private final ItemStack outputItemStack;
    private final ItemStack redstoneTimerItemStack;
    private final int processingTime;

    public RoasterRecipe(ResourceLocation recipeId, ItemStack inputItemStack, ItemStack outputItemStack, ItemStack redstoneTimerItemStack) {
        this.recipeId = recipeId;
        this.inputItemStack = inputItemStack;
        this.outputItemStack = outputItemStack;
        this.redstoneTimerItemStack = redstoneTimerItemStack;
        this.processingTime = redstoneTimerItemStack.func_190916_E() * 200 + 200;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public boolean matches(ItemStack itemStack, ItemStack redstoneTimerItemStack) {
        boolean redstoneValid;
        boolean inputValid = this.inputItemStack.func_77973_b() == itemStack.func_77973_b() && this.inputItemStack.func_190916_E() <= itemStack.func_190916_E();
        boolean bl = redstoneValid = this.redstoneTimerItemStack.func_77973_b() == redstoneTimerItemStack.func_77973_b() && this.redstoneTimerItemStack.func_190916_E() == redstoneTimerItemStack.func_190916_E();
        if (inputValid && redstoneValid && this.outputItemStack.func_190916_E() > 1) {
            this.outputItemStack.func_190920_e(1);
        }
        return inputValid && redstoneValid;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.inputItemStack, this.redstoneTimerItemStack})});
    }

    public ItemStack getInputItemStack() {
        Objects.requireNonNull(this.inputItemStack, String.format("Recipe input cannot be null! Check recipe (%s) json file.", this.recipeId));
        return this.inputItemStack;
    }

    public ItemStack func_77572_b(IInventory inv) {
        Objects.requireNonNull(this.outputItemStack, String.format("Recipe output cannot be null. Check recipe (%s) json file.", this.recipeId));
        return this.outputItemStack;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.outputItemStack;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)GrowthcraftCellarRecipes.ROASTER_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return GrowthcraftCellarRecipes.ROASTER_RECIPE_TYPE;
    }

    public String func_193358_e() {
        return "growthcraft";
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public ItemStack getOutputItem() {
        return this.outputItemStack;
    }

    public ResourceLocation getRecipeID() {
        return this.recipeId;
    }

    public ItemStack getRedstoneTimerItemStack() {
        return this.redstoneTimerItemStack;
    }
}

