/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.init;

import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.block.BrewKettleBlock;
import growthcraft.cellar.common.block.CultureJarBlock;
import growthcraft.cellar.common.block.FermentationBarrelBlock;
import growthcraft.cellar.common.block.FruitPressBlock;
import growthcraft.cellar.common.block.FruitPressPistonBlock;
import growthcraft.cellar.common.block.RoasterBlock;
import growthcraft.cellar.common.block.crop.GrapeCrop;
import growthcraft.cellar.common.block.crop.GrapeVineCrop;
import growthcraft.cellar.common.block.crop.GrapeVineLeavesCrop;
import growthcraft.cellar.common.block.crop.HopsCrop;
import growthcraft.cellar.shared.UnlocalizedName;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GrowthcraftCellarBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"growthcraft_cellar");
    public static final RegistryObject<FruitPressBlock> FRUIT_PRESS = BLOCKS.register("fruit_press", FruitPressBlock::new);
    public static final RegistryObject<FruitPressPistonBlock> FRUIT_PRESS_PISTON = BLOCKS.register("fruit_press_piston", FruitPressPistonBlock::new);
    public static final RegistryObject<FermentationBarrelBlock> barrel_ferment_oak = BLOCKS.register("barrel_ferment_oak", FermentationBarrelBlock::new);
    public static final RegistryObject<BrewKettleBlock> brew_kettle = BLOCKS.register("brew_kettle", BrewKettleBlock::new);
    public static final RegistryObject<CultureJarBlock> culture_jar = BLOCKS.register("culture_jar", CultureJarBlock::new);
    public static final RegistryObject<RoasterBlock> roaster = BLOCKS.register("roaster", RoasterBlock::new);
    public static final RegistryObject<HopsCrop> hops_vine = BLOCKS.register("hops_vine", HopsCrop::new);
    public static final RegistryObject<GrapeCrop> GRAPE_VINE_CROP = BLOCKS.register("grape_vine_crop", GrapeCrop::new);
    public static final RegistryObject<GrapeVineCrop> GRAPE_VINE = BLOCKS.register("grape_vine", GrapeVineCrop::new);
    public static final RegistryObject<GrapeVineLeavesCrop> GRAPE_VINE_LEAVES = BLOCKS.register("grape_vine_leaves", GrapeVineLeavesCrop::new);

    private GrowthcraftCellarBlocks() {
    }

    public static void registerBlockItems(IForgeRegistry<Item> itemRegistry, Item.Properties properties) {
        GrowthcraftCellar.LOGGER.debug("<Growthcraft-Cellar> Registration of itemBlocks started ...");
        BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            BlockItem blockItem = new BlockItem(block, properties);
            if (block.getRegistryName() != null && !GrowthcraftCellarBlocks.excludeBlockItemRegistry(block.getRegistryName())) {
                blockItem.setRegistryName(block.getRegistryName());
                itemRegistry.register((IForgeRegistryEntry)blockItem);
            }
        });
        GrowthcraftCellar.LOGGER.debug("<Growthcraft-Cellar> Registration of itemBlocks finished.");
    }

    private static boolean excludeBlockItemRegistry(ResourceLocation registryName) {
        ArrayList<String> excludeBlocks = new ArrayList<String>();
        excludeBlocks.add("growthcraft_cellar:fruit_press_piston");
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("amber_ale").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("amber_lager").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("brown_ale").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("copper_ale").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("pale_ale").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("old_port_ale").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("stout_ale").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("pilsner_lager").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("dark_lager").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("ipa_ale").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("vienna_lager").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("pale_lager").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("brown_lager").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("copper_lager").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("pale_golden_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("golden_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("amber_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("deep_amber_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("copper_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("deep_copper_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("brown_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("dark_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("red_grape_juice").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("white_grape_juice").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("purple_grape_juice").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("hopped_golden_wort").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("red_wine").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("purple_wine").get("block"));
        excludeBlocks.add("growthcraft_cellar:" + UnlocalizedName.getFluidNames("white_wine").get("block"));
        excludeBlocks.add("growthcraft_cellar:hops_vine");
        excludeBlocks.add("growthcraft_cellar:grape_vine_crop");
        excludeBlocks.add("growthcraft_cellar:grape_vine");
        excludeBlocks.add("growthcraft_cellar:grape_vine_leaves");
        return excludeBlocks.contains(registryName.toString());
    }
}

