/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.lib.common.tank.handler;

import growthcraft.lib.common.tank.NonInteractiveTank;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTankOutputHandler {
    private final Map<Integer, NonInteractiveTank> fluidTanks = new HashMap<Integer, NonInteractiveTank>();

    public FluidTankOutputHandler(int tanks, int capacity) {
        this.createFluidTanks(tanks, capacity);
    }

    private void createFluidTanks(int tanks, int capacity) {
        for (int i = 0; i < tanks; ++i) {
            this.fluidTanks.put(i, new NonInteractiveTank(capacity));
        }
    }

    public NonInteractiveTank getTank(int tank) {
        return this.fluidTanks.get(tank);
    }

    public LazyOptional<IFluidHandler> getFluidTankHandler(int tank) {
        return LazyOptional.of(() -> this.getTank(tank));
    }

    public int getNumberTanks() {
        return this.fluidTanks.size();
    }

    public void updateFluidTank(int tank, NonInteractiveTank fluidTank) {
        this.fluidTanks.put(tank, fluidTank);
    }

    public void drain(int index, int amount) {
        this.getTank(index).drain(amount, IFluidHandler.FluidAction.EXECUTE);
    }
}

