/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.lib.util;

import growthcraft.cellar.common.recipe.FermentBarrelRecipe;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class RecipeUtils {
    public static FermentBarrelRecipe findFermentRecipeByResult(World world, FluidStack fluidStack) {
        Set<IRecipe<?>> recipes = RecipeUtils.findRecipesByType(world, GrowthcraftCellarRecipes.FERMENT_BARREL_RECIPE_TYPE);
        ArrayList<FermentBarrelRecipe> matchingRecipes = new ArrayList<FermentBarrelRecipe>();
        for (IRecipe<?> recipe : recipes) {
            FermentBarrelRecipe fermentBarrelRecipe = (FermentBarrelRecipe)recipe;
            if (!fermentBarrelRecipe.matches(fluidStack)) continue;
            matchingRecipes.add(fermentBarrelRecipe);
        }
        return matchingRecipes.size() > 0 ? (FermentBarrelRecipe)matchingRecipes.get(0) : null;
    }

    public static List<FermentBarrelRecipe> findFermentRecipesByResult(World world, FluidStack fluidStack) {
        Set<IRecipe<?>> recipes = RecipeUtils.findRecipesByType(world, GrowthcraftCellarRecipes.FERMENT_BARREL_RECIPE_TYPE);
        ArrayList<FermentBarrelRecipe> matchingRecipes = new ArrayList<FermentBarrelRecipe>();
        for (IRecipe<?> recipe : recipes) {
            FermentBarrelRecipe fermentBarrelRecipe = (FermentBarrelRecipe)recipe;
            if (!fermentBarrelRecipe.matches(fluidStack)) continue;
            matchingRecipes.add(fermentBarrelRecipe);
        }
        return matchingRecipes;
    }

    public static List<FermentBarrelRecipe> findFermentRecipes() {
        Set<IRecipe<?>> recipes = RecipeUtils.findRecipesByType((World)Minecraft.func_71410_x().field_71441_e, GrowthcraftCellarRecipes.FERMENT_BARREL_RECIPE_TYPE);
        ArrayList<FermentBarrelRecipe> matchingRecipes = new ArrayList<FermentBarrelRecipe>();
        for (IRecipe<?> recipe : recipes) {
            if (!(recipe instanceof FermentBarrelRecipe)) continue;
            matchingRecipes.add((FermentBarrelRecipe)recipe);
        }
        return matchingRecipes;
    }

    public static Set<IRecipe<?>> findRecipesByType(World world, IRecipeType<?> recipeType) {
        return world != null ? world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g().toString().equals(recipeType.toString())).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public static Set<IRecipe<?>> findRecipesByType(IRecipeType<?> recipeType) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        return world != null ? world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g().toString().equals(recipeType.toString())).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public static class InvalidRecipeFile
    extends Exception {
        public InvalidRecipeFile(String message) {
            super(message);
        }
    }

    public static class ToManyMatchingRecipes
    extends Exception {
        public ToManyMatchingRecipes(String message) {
            super(message);
        }
    }
}

