/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.milk.common.tileentity.PancheonTileEntity;
import growthcraft.milk.init.GrowthcraftMilkFluids;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import growthcraft.milk.init.config.GrowthcraftMilkConfig;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class PancheonBlock
extends HorizontalBlock {
    public static final BooleanProperty LOCKED = BooleanProperty.func_177716_a((String)"is_locked");
    public static final VoxelShape BASE_BOUNDING_BOX = PancheonBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    public static final VoxelShape INSIDE_BOUNDING_BOX = PancheonBlock.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);

    public PancheonBlock() {
        this(PancheonBlock.getInitProperties());
    }

    public PancheonBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150348_b);
        properties.func_200943_b(1.5f);
        properties.func_226896_b_();
        return properties;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftMilkTileEntities.PANCHEON_TILE_ENTITY.get()).func_200968_a();
    }

    @ParametersAreNonnullByDefault
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, LOCKED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        PancheonTileEntity tileEntity = (PancheonTileEntity)worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && handIn.name().equals("MAIN_HAND") && player.func_184614_ca().func_77973_b() == Items.field_151117_aB) {
            FluidStack milkBucketFluidStack = new FluidStack(((FlowingFluidBlock)GrowthcraftMilkFluids.MILK_FLUID_BLOCK.get()).getFluid().getFluid(), 1000);
            if (tileEntity.isFluidEmpty() || tileEntity.getFluidTank(0).getFluidAmount() == 1000) {
                tileEntity.getFluidTank(0).fill(milkBucketFluidStack, IFluidHandler.FluidAction.EXECUTE);
                player.func_184614_ca().func_190918_g(1);
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151133_ar));
                tileEntity.func_70296_d();
                worldIn.func_184138_a(pos, state, state, 2);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        if (!worldIn.field_72995_K && player.func_225608_bj_() && GrowthcraftMilkConfig.isPancheonGuiEnabled()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, (BlockPos)pos);
            return ActionResultType.SUCCESS;
        }
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b()) || player.func_184586_b(handIn).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197878_a((VoxelShape)BASE_BOUNDING_BOX, (VoxelShape)INSIDE_BOUNDING_BOX, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    }
}

