/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.recipe;

import growthcraft.milk.common.recipe.MixingVatRecipe;
import growthcraft.milk.init.GrowthcraftMilkRecipes;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class MixingVatItemRecipe
extends MixingVatRecipe {
    private final ItemStack resultItemStack;
    private final ItemStack resultActivationTool;

    public MixingVatItemRecipe(ResourceLocation recipeId, MixingVatRecipe.MixingVatRecipeCategory category, FluidStack inputFluidStack, List<ItemStack> ingredients, int processingTime, ItemStack resultItemStack, ItemStack activationTool, ItemStack resultActivationTool) {
        super(recipeId, category, inputFluidStack, ingredients, processingTime, activationTool);
        this.resultItemStack = resultItemStack;
        this.resultActivationTool = resultActivationTool;
    }

    @Override
    public IRecipeType<?> func_222127_g() {
        return GrowthcraftMilkRecipes.MIXING_VAT_ITEM_RECIPE_TYPE;
    }

    public boolean matches(FluidStack testFluidStack, List<ItemStack> testIngredients) {
        boolean fluidMatches = false;
        boolean itemMatches = false;
        if (testFluidStack.getFluid() == this.getInputFluidStack().getFluid() && testFluidStack.getAmount() == this.getInputFluidStack().getAmount()) {
            fluidMatches = true;
        }
        if (this.getIngredientList().size() == testIngredients.size()) {
            int itemCount = this.getIngredientList().size();
            int matchCount = 0;
            for (int i = 0; i < this.getIngredientList().size(); ++i) {
                if (this.getIngredientList().get(i).func_77973_b() != testIngredients.get(i).func_77973_b() || this.getIngredientList().get(i).func_190916_E() != testIngredients.get(i).func_190916_E()) continue;
                ++matchCount;
            }
            if (itemCount == matchCount) {
                itemMatches = true;
            }
        }
        return fluidMatches && itemMatches;
    }

    public boolean matchResult(ItemStack itemStack) {
        return this.resultItemStack.func_77973_b() == itemStack.func_77973_b() && this.resultItemStack.func_190916_E() == itemStack.func_190916_E();
    }

    public ItemStack getResultItemStack() {
        return this.resultItemStack.func_77946_l();
    }

    public ItemStack getResultActivationTool() {
        return this.resultActivationTool;
    }

    @Override
    public ItemStack func_77571_b() {
        return this.getResultItemStack();
    }
}

