/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.cellar.common.tileentity.handler.GrowthcraftItemHandler;
import growthcraft.milk.common.recipe.CheesePressRecipe;
import growthcraft.milk.init.GrowthcraftMilkRecipes;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CheesePressTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int INPUT_INVENTORY_SLOTS = 1;
    private final GrowthcraftItemHandler inventory = new GrowthcraftItemHandler(1, new ItemStack[0]);
    private boolean open = true;
    private int rotation = 0;
    private ITextComponent customName;
    private CheesePressRecipe currentRecipe;
    private int currentProcessingTicks;
    private int maxProcessingTicks;

    public CheesePressTileEntity() {
        this((TileEntityType)GrowthcraftMilkTileEntities.CHEESE_PRESS_TILE_ENTITY.get());
    }

    public CheesePressTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory.toNonNullList();
    }

    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
        this.inventory.setNonNullList(nonNullList);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_milk", "cheese_press");
        return new TranslationTextComponent(translationKey);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return null;
    }

    public int func_70302_i_() {
        return 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && !this.inventory.getStackInSlot(0).func_190926_b() && this.getRotation() == 7 && this.isRecipeCurrent()) {
            if (this.currentProcessingTicks < this.maxProcessingTicks) {
                ++this.currentProcessingTicks;
                this.func_70296_d();
            } else {
                this.processCurrentRecipe();
            }
        }
    }

    private boolean isRecipeCurrent() {
        List cheesePressRecipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftMilkRecipes.CHEESE_PRESS_RECIPE_TYPE);
        for (CheesePressRecipe cheesePressRecipe : cheesePressRecipes) {
            if (!cheesePressRecipe.matches(this.inventory.getStackInSlot(0))) continue;
            if (this.currentRecipe != null && this.currentRecipe == cheesePressRecipe) {
                return true;
            }
            this.currentRecipe = cheesePressRecipe;
            this.currentProcessingTicks = 0;
            this.maxProcessingTicks = cheesePressRecipe.getProcessingTime();
            return true;
        }
        return false;
    }

    public void processCurrentRecipe() {
        if (this.currentRecipe != null) {
            this.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
            this.getInventory().insertItem(0, this.currentRecipe.func_77571_b(), false);
            this.resetProcessing();
        }
    }

    public void resetProcessing() {
        this.currentRecipe = null;
        this.currentProcessingTicks = 0;
        this.maxProcessingTicks = 0;
        this.func_70296_d();
    }

    public int doRotation(boolean increase) {
        if (this.rotation == 7 && increase) {
            return this.getRotation();
        }
        if (this.rotation == 0 && !increase) {
            return this.getRotation();
        }
        this.rotation = increase ? ++this.rotation : 0;
        this.open = this.rotation == 0;
        return this.getRotation();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.currentProcessingTicks = compound.func_74762_e("CurrentProcessingTicks");
        this.open = compound.func_74767_n("IsOpen");
        this.rotation = compound.func_74762_e("rotation");
        NonNullList inv = NonNullList.func_191197_a((int)this.inventory.getSlots(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)inv);
        this.inventory.setNonNullList((NonNullList<ItemStack>)inv);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74768_a("CurrentProcessingTicks", this.currentProcessingTicks);
        compound.func_74757_a("IsOpen", this.isOpen());
        compound.func_74768_a("rotation", this.getRotation());
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory.toNonNullList());
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    private boolean tryPlaceItemInventory(ItemStack itemStack) {
        for (int i = 0; i < 1; ++i) {
            if (!this.getInventory().getStackInSlot(i).func_190926_b()) continue;
            this.getInventory().insertItem(i, itemStack, false);
            if (this.getInventory().getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public GrowthcraftItemHandler getInventory() {
        return this.inventory;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isOpen() {
        return this.open;
    }
}

