/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.lib.common.tank.handler.FluidTankHandler;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.client.container.ChurnContainer;
import growthcraft.milk.common.block.ChurnBlock;
import growthcraft.milk.common.recipe.ChurnRecipe;
import growthcraft.milk.init.GrowthcraftMilkRecipes;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import java.security.SecureRandom;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ChurnTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final IItemHandlerModifiable items = this.createHandler();
    private final LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    private int currentNumberPlunges;
    private ITextComponent customName;
    private FluidTankHandler fluidTankHandler;
    private NonNullList<ItemStack> inventoryItemStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private int maxNumberPlunges;
    private boolean plunged;
    private boolean plungerLocked;
    private ChurnRecipe currentRecipe;

    public ChurnTileEntity() {
        this((TileEntityType)GrowthcraftMilkTileEntities.CHURN_TILE_ENTITY.get());
    }

    protected ChurnTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.createFluidTanks();
        this.plunged = false;
        this.plungerLocked = true;
    }

    private void createFluidTanks() {
        this.fluidTankHandler = new FluidTankHandler(1, 1000);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this);
    }

    public void togglePlunger() {
        if (!this.field_145850_b.func_201670_d()) {
            if (!this.plungerLocked) {
                if (this.plunged) {
                    this.playSound(null, SoundEvents.field_187883_gR);
                    this.plunged = false;
                } else {
                    this.playSound(null, SoundEvents.field_187885_gS);
                    this.plunged = true;
                    this.incrementPlunges(1);
                }
            }
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)ChurnBlock.PLUNGED, (Comparable)Boolean.valueOf(this.isPlunged())));
        }
    }

    public void incrementPlunges(int i) {
        boolean dirty = false;
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)ChurnBlock.PLUNGED, (Comparable)Boolean.valueOf(this.isPlunged())));
        if (!this.field_145850_b.func_201670_d()) {
            if (!this.fluidTankHandler.getTank(0).isEmpty() && this.items.getStackInSlot(0).func_190926_b()) {
                if (this.currentRecipe != null) {
                    if (this.currentNumberPlunges >= this.maxNumberPlunges) {
                        this.fluidTankHandler.getTank(0).drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        this.fluidTankHandler.getTank(0).fill(this.currentRecipe.getOutputFluidStack(), IFluidHandler.FluidAction.EXECUTE);
                        int randomness = new SecureRandom().nextInt(100);
                        if (randomness <= this.currentRecipe.getByProductChance()) {
                            this.items.insertItem(0, this.currentRecipe.getResultItemStack().func_77946_l(), false);
                        }
                        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)ChurnBlock.PLUNGED, (Comparable)Boolean.valueOf(false)));
                        this.currentRecipe = null;
                        this.currentNumberPlunges = 0;
                        this.plungerLocked = true;
                    } else {
                        this.currentNumberPlunges += i;
                    }
                    dirty = true;
                } else {
                    GrowthcraftMilk.LOGGER.error("No recipe found");
                    this.plungerLocked = true;
                }
            } else {
                this.currentRecipe = null;
                this.currentNumberPlunges = 0;
                this.plungerLocked = true;
            }
        }
        if (dirty) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void playSound(@Nullable PlayerEntity player, SoundEvent sound) {
        double dx = (double)this.field_174879_c.func_177958_n() + 0.5;
        double dy = (double)this.field_174879_c.func_177956_o() + 0.5;
        double dz = (double)this.field_174879_c.func_177952_p() + 0.5;
        assert (this.field_145850_b != null);
        this.field_145850_b.func_184148_a(player, dx, dy, dz, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            ChurnRecipe recipe;
            boolean dirty = false;
            if (!this.fluidTankHandler.getTank(0).isEmpty() && this.items.getStackInSlot(0).func_190926_b() && (recipe = this.getRecipe(this.fluidTankHandler.getTank(0).getFluid())) != null && recipe != this.currentRecipe) {
                this.currentRecipe = recipe;
                this.maxNumberPlunges = recipe.getPlungesNeeded();
                this.plungerLocked = false;
                dirty = true;
            }
            if (dirty) {
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            }
        }
    }

    public FluidTank getFluidTank(int slot) {
        switch (slot) {
            case 0: {
                return this.fluidTankHandler.getTank(0);
            }
        }
        return null;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private ChurnRecipe getRecipe(FluidStack fluidStack) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftMilkRecipes.CHURN_RECIPE_TYPE);
        for (ChurnRecipe recipe : recipes) {
            if (!recipe.matches(fluidStack)) continue;
            return recipe;
        }
        return null;
    }

    public IItemHandler getInventory() {
        return this.items;
    }

    public int func_70302_i_() {
        return this.inventoryItemStacks.size();
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventoryItemStacks;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventoryItemStacks = itemsIn;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_milk", "churn");
        return new TranslationTextComponent(translationKey);
    }

    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new ChurnContainer(windowId, playerInventory, this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.inventoryItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventoryItemStacks);
        }
        this.currentNumberPlunges = compound.func_74762_e("CurrentProcessingTicks");
        this.maxNumberPlunges = compound.func_74762_e("MaxNumberPlunges");
        this.plunged = compound.func_74767_n("Plunged");
        this.getFluidTankHandler().getTank(0).readFromNBT(compound.func_74775_l("tank0"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventoryItemStacks);
        compound.func_74768_a("CurrentNumberPlunges", this.currentNumberPlunges);
        compound.func_74768_a("MaxNumberPlunges", this.maxNumberPlunges);
        compound.func_74757_a("Plunged", this.plunged);
        compound.func_218657_a("tank0", (INBT)this.getFluidTankHandler().getTank(0).writeToNBT(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidTankHandler.getFluidTankHandler(0).cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isPlunged() {
        return this.plunged;
    }

    public int getCurrentNumberPlunges() {
        return this.currentNumberPlunges;
    }

    public int getMaxNumberPlunges() {
        return this.maxNumberPlunges;
    }

    public FluidTankHandler getFluidTankHandler() {
        return this.fluidTankHandler;
    }
}

