/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.lib.common.block;

import growthcraft.milk.common.tileentity.CheeseWheelTileEntity;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CheeseWheelBlock
extends HorizontalBlock {
    public static final BooleanProperty AGED = BooleanProperty.func_177716_a((String)"aged");
    public static final IntegerProperty SLICE_COUNT_TOP = IntegerProperty.func_177719_a((String)"slicestop", (int)0, (int)4);
    public static final IntegerProperty SLICE_COUNT_BOTTOM = IntegerProperty.func_177719_a((String)"slicesbottom", (int)0, (int)4);
    public static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape BOUNDING_BOX_HALF = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private final int color;

    public CheeseWheelBlock(Color color) {
        super(CheeseWheelBlock.getInitProperties());
        this.color = color.getRGB();
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)SLICE_COUNT_BOTTOM, (Comparable)Integer.valueOf(4))).func_206870_a((Property)SLICE_COUNT_TOP, (Comparable)Integer.valueOf(0))).func_206870_a((Property)AGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 10;
    }

    public static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150414_aQ);
        properties.func_200943_b(1.5f);
        properties.func_226896_b_();
        return properties;
    }

    @ParametersAreNonnullByDefault
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, SLICE_COUNT_BOTTOM, SLICE_COUNT_TOP, AGED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftMilkTileEntities.CHEESE_WHEEL_TILE_ENTITY.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && handIn.name().equals("MAIN_HAND")) {
            CheeseWheelTileEntity tileEntity = (CheeseWheelTileEntity)worldIn.func_175625_s(pos);
            if (player.func_184614_ca().func_77973_b() == this.func_199767_j()) {
                tileEntity.addSlice(4);
                player.func_184614_ca().func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            if (!player.func_225608_bj_() && player.func_184614_ca().func_190926_b() && tileEntity.canTakeSlice()) {
                player.field_71071_by.func_70441_a(tileEntity.takeSlice());
                return ActionResultType.SUCCESS;
            }
            if (player.func_225608_bj_() && (tileEntity.getSliceCount() > 4 || tileEntity.getSliceCount() == 4)) {
                tileEntity.takeSlice(4);
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)this.func_199767_j()));
                return ActionResultType.SUCCESS;
            }
            if (tileEntity.getSliceCount() == 0) {
                worldIn.func_175655_b(pos, false);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Integer)state.func_177229_b((Property)SLICE_COUNT_TOP) > 0 ? BOUNDING_BOX : BOUNDING_BOX_HALF;
    }

    public int getColor() {
        return this.color;
    }

    public int getColor(int i) {
        return i == 0 ? this.color : 0xFFFFFF;
    }
}

