/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.mixin.BlockPropertiesAccessor;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.TriPredicate;

public class BlockProperties {
    private final Material material;
    private final MaterialColor mapColor;
    private boolean hasCollision = true;
    private boolean canOcclude = true;
    private SoundType soundType = SoundType.field_185851_d;
    private ToIntFunction<BlockState> lightLevel = state -> 0;
    private float explosionResistance;
    private float destroyTime;
    private boolean requiresCorrectTool = false;
    private boolean ticksRandomly = false;
    private float friction = 0.6f;
    private float speedFactor = 1.0f;
    private float jumpFactor = 1.0f;
    private boolean isAir = false;
    private TriPredicate<BlockState, IBlockReader, BlockPos> isRedstoneConductor = (state, level, pos) -> state.func_185904_a().func_76218_k() && state.func_235785_r_(level, pos);
    private TriPredicate<BlockState, IBlockReader, BlockPos> isSuffocating = (state, level, pos) -> state.func_185904_a().func_76230_c() && state.func_235785_r_(level, pos);
    private boolean hasDynamicShape = false;
    private boolean noLootTable = false;
    private Supplier<ResourceLocation> lootTableSupplier;

    public static BlockProperties create(Material material, MaterialColor color) {
        return new BlockProperties(material, color);
    }

    public static BlockProperties create(Material material, DyeColor color) {
        return new BlockProperties(material, color.func_196055_e());
    }

    public static BlockProperties create(Material material) {
        return new BlockProperties(material, material.func_151565_r());
    }

    public static BlockProperties copy(Block block) {
        AbstractBlock.Properties sourceProperties = block.field_235684_aB_;
        BlockProperties properties = BlockProperties.create(sourceProperties.field_200953_a, block.func_235697_s_());
        properties.hasCollision = sourceProperties.field_200955_c;
        properties.canOcclude = block.func_176223_P().func_200132_m();
        properties.soundType = block.func_220072_p(block.func_176223_P());
        properties.lightLevel = sourceProperties.field_235803_e_;
        properties.explosionResistance = block.func_149638_a();
        properties.destroyTime = sourceProperties.field_200959_g;
        properties.requiresCorrectTool = block.func_176223_P().func_235783_q_();
        properties.ticksRandomly = block.func_149653_t(block.func_176223_P());
        properties.friction = block.func_208618_m();
        properties.speedFactor = block.func_226891_m_();
        properties.jumpFactor = block.func_226892_n_();
        properties.isAir = block.func_176223_P().func_196958_f();
        properties.isRedstoneConductor = (arg_0, arg_1, arg_2) -> ((AbstractBlock.IPositionPredicate)sourceProperties.field_235815_q_).test(arg_0, arg_1, arg_2);
        properties.isSuffocating = (arg_0, arg_1, arg_2) -> ((AbstractBlock.IPositionPredicate)sourceProperties.field_235816_r_).test(arg_0, arg_1, arg_2);
        properties.hasDynamicShape = block.func_208619_r();
        properties.lootTableSupplier = sourceProperties.field_222381_j != null ? () -> sourceProperties.field_222381_j : ((BlockPropertiesAccessor)sourceProperties).getLootTableSupplier();
        return properties;
    }

    private BlockProperties(Material material, MaterialColor color) {
        this.material = material;
        this.mapColor = color;
    }

    public BlockProperties noCollision() {
        this.hasCollision = false;
        this.canOcclude = false;
        return this;
    }

    public BlockProperties noOcclusion() {
        this.canOcclude = false;
        return this;
    }

    public BlockProperties sound(SoundType soundTypeIn) {
        this.soundType = soundTypeIn;
        return this;
    }

    public BlockProperties lightLevel(ToIntFunction<BlockState> stateLightFunction) {
        this.lightLevel = stateLightFunction;
        return this;
    }

    public BlockProperties lightLevel(int light) {
        this.lightLevel = state -> light;
        return this;
    }

    public BlockProperties explosionResistance(float resistance) {
        this.explosionResistance = Math.max(0.0f, resistance);
        return this;
    }

    public BlockProperties destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockProperties requiresCorrectTool() {
        this.requiresCorrectTool = true;
        return this;
    }

    public BlockProperties randomTicks() {
        this.ticksRandomly = true;
        return this;
    }

    public BlockProperties friction(float friction) {
        this.friction = friction;
        return this;
    }

    public BlockProperties speedFactor(float factor) {
        this.speedFactor = factor;
        return this;
    }

    public BlockProperties jumpFactor(float factor) {
        this.jumpFactor = factor;
        return this;
    }

    public BlockProperties air() {
        this.isAir = true;
        return this;
    }

    public BlockProperties isRedstoneConductor(TriPredicate<BlockState, IBlockReader, BlockPos> isRedstoneConductor) {
        this.isRedstoneConductor = isRedstoneConductor;
        return this;
    }

    public BlockProperties isRedstoneConductor(boolean isRedstoneConductor) {
        this.isRedstoneConductor = (state, blockGetter, pos) -> isRedstoneConductor;
        return this;
    }

    public BlockProperties isSuffocating(TriPredicate<BlockState, IBlockReader, BlockPos> isSuffocating) {
        this.isSuffocating = isSuffocating;
        return this;
    }

    public BlockProperties isSuffocating(boolean isSuffocating) {
        this.isSuffocating = (state, blockGetter, pos) -> isSuffocating;
        return this;
    }

    public BlockProperties dynamicShape() {
        this.hasDynamicShape = true;
        return this;
    }

    public BlockProperties noLootTable() {
        this.noLootTable = true;
        this.lootTableSupplier = null;
        return this;
    }

    public BlockProperties lootTable(ResourceLocation lootTable) {
        this.noLootTable = false;
        this.lootTableSupplier = () -> lootTable;
        return this;
    }

    public BlockProperties lootTableFrom(Supplier<Block> block) {
        this.noLootTable = false;
        this.lootTableSupplier = block == null ? null : () -> ((Block)block.get()).func_220068_i();
        return this;
    }

    @Deprecated
    public AbstractBlock.Properties toUnderlying() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200949_a((Material)this.material, (MaterialColor)this.mapColor);
        if (!this.hasCollision) {
            properties.func_200942_a();
        }
        properties.func_200947_a(this.soundType);
        properties.func_235838_a_(this.lightLevel);
        properties.func_200943_b(this.explosionResistance);
        properties.field_200959_g = this.destroyTime;
        if (this.requiresCorrectTool) {
            properties.func_235861_h_();
        }
        if (this.ticksRandomly) {
            properties.func_200944_c();
        }
        properties.func_200941_a(this.friction);
        properties.func_226897_b_(this.speedFactor);
        properties.func_226898_c_(this.jumpFactor);
        if (this.noLootTable) {
            properties.func_222380_e();
        }
        ((BlockPropertiesAccessor)properties).setLootTableSupplier(this.lootTableSupplier);
        if (!this.canOcclude) {
            properties.func_226896_b_();
        }
        if (this.isAir) {
            properties.func_235859_g_();
        }
        properties.func_235828_a_((arg_0, arg_1, arg_2) -> this.isRedstoneConductor.test(arg_0, arg_1, arg_2));
        properties.func_235842_b_((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        properties.func_235847_c_((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        if (this.hasDynamicShape) {
            properties.func_208770_d();
        }
        return properties;
    }
}

