/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class ScreenUtils {
    private static final ResourceLocation BUTTON_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/buttons.png");
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/background.png");
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int ACTIVE_TEXT_COLOR = 0xE0E0E0;
    public static final int INACTIVE_TEXT_COLOR = 0x707070;

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243248_b(matrixStack, text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243248_b(matrixStack, text, x, y, 0x404040);
    }

    public static void drawString(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243246_a(matrixStack, text, x, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243246_a(matrixStack, text, x, y, 0x404040);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243248_b(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243248_b(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredString(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243246_a(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243246_a(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238421_b_(matrixStack, text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238421_b_(matrixStack, text, x, y, 0x404040);
    }

    public static void drawString(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238421_b_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238421_b_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredString(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawScreenBackground(MatrixStack matrixStack, float x, float y, float width, float height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SCREEN_BACKGROUND);
        ScreenUtils.drawTexture(matrixStack, x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(matrixStack, x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(matrixStack, x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public static void drawButtonBackground(MatrixStack matrixStack, float x, float y, float width, float height, float yOffset) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BUTTON_BACKGROUND);
        ScreenUtils.drawTexture(matrixStack, x, y, 2.0f, 2.0f, 0.0f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + width - 2.0f, y, 2.0f, 2.0f, 0.6f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + width - 2.0f, y + height - 2.0f, 2.0f, 2.0f, 0.6f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x, y + height - 2.0f, 2.0f, 2.0f, 0.0f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + 2.0f, y, width - 4.0f, 2.0f, 0.4f, yOffset, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + 2.0f, y + height - 2.0f, width - 4.0f, 2.0f, 0.4f, yOffset + 0.2f, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x, y + 2.0f, 2.0f, height - 4.0f, 0.0f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(matrixStack, x + width - 2.0f, y + 2.0f, 2.0f, height - 4.0f, 0.6f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(matrixStack, x + 2.0f, y + 2.0f, width - 4.0f, height - 4.0f, 0.4f, yOffset + 0.13333334f, 0.2f, 0.06666667f);
    }

    public static void drawTexture(MatrixStack matrixStack, float x, float y, float width, float height) {
        ScreenUtils.drawTexture(matrixStack, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(MatrixStack matrixStack, float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, x, y + height, 0.0f).func_225583_a_(tx, ty + theight).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(tx + twidth, ty + theight).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, 0.0f).func_225583_a_(tx + twidth, ty).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(tx, ty).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void fillRect(MatrixStack matrixStack, float x, float y, float width, float height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ScreenUtils.fillRect(matrixStack, x, y, width, height, red, green, blue, alpha);
    }

    public static void fillRect(MatrixStack matrixStack, float x, float y, float width, float height, float red, float green, float blue, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix, x, y + height, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        tesselator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
    }

    public static void drawTooltip(MatrixStack poseStack, FontRenderer fontRenderer, List<ITextComponent> text, int x, int y) {
        ScreenUtils.drawTooltipInternal(poseStack, fontRenderer, text.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList()), x, y);
    }

    public static void drawTooltip(MatrixStack poseStack, FontRenderer fontRenderer, ITextComponent text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, Collections.singletonList(text), x, y);
    }

    public static void drawTooltip(MatrixStack poseStack, FontRenderer fontRenderer, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, fontRenderer, (ITextComponent)new StringTextComponent(text), x, y);
    }

    public static void drawTooltip(MatrixStack poseStack, List<ITextComponent> text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(MatrixStack poseStack, ITextComponent text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(MatrixStack poseStack, String text, int x, int y) {
        ScreenUtils.drawTooltip(poseStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    /*
     * WARNING - void declaration
     */
    private static void drawTooltipInternal(MatrixStack poseStack, FontRenderer fontRenderer, List<? extends IReorderingProcessor> components, int x, int y) {
        int n;
        if (components.isEmpty()) {
            return;
        }
        int windowWidth = ClientUtils.getMinecraft().func_228018_at_().func_198107_o();
        int windowHeight = ClientUtils.getMinecraft().func_228018_at_().func_198087_p();
        int tooltipWidth = 0;
        int tooltipHeight = components.size() == 1 ? -2 : 0;
        for (IReorderingProcessor iReorderingProcessor : components) {
            int componentWidth = fontRenderer.func_243245_a(iReorderingProcessor);
            if (componentWidth > tooltipWidth) {
                tooltipWidth = componentWidth;
            }
            tooltipHeight += 10;
        }
        int tooltipX = x + 12;
        int n2 = y - 12;
        if (tooltipX + tooltipWidth > windowWidth) {
            tooltipX -= 28 + tooltipWidth;
        }
        if (n2 + tooltipHeight + 6 > windowHeight) {
            int n3 = windowHeight - tooltipHeight - 6;
        }
        if (y - tooltipHeight - 8 < 0) {
            n = y + 8;
        }
        poseStack.func_227860_a_();
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tesselator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(n - 4), (int)(tooltipX + tooltipWidth + 3), (int)(n - 3), (int)400, (int)-267386864, (int)-267386864);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(n + tooltipHeight + 3), (int)(tooltipX + tooltipWidth + 3), (int)(n + tooltipHeight + 4), (int)400, (int)-267386864, (int)-267386864);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(n - 3), (int)(tooltipX + tooltipWidth + 3), (int)(n + tooltipHeight + 3), (int)400, (int)-267386864, (int)-267386864);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 4), (int)(n - 3), (int)(tooltipX - 3), (int)(n + tooltipHeight + 3), (int)400, (int)-267386864, (int)-267386864);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX + tooltipWidth + 3), (int)(n - 3), (int)(tooltipX + tooltipWidth + 4), (int)(n + tooltipHeight + 3), (int)400, (int)-267386864, (int)-267386864);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(n - 3 + 1), (int)(tooltipX - 3 + 1), (int)(n + tooltipHeight + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX + tooltipWidth + 2), (int)(n - 3 + 1), (int)(tooltipX + tooltipWidth + 3), (int)(n + tooltipHeight + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(n - 3), (int)(tooltipX + tooltipWidth + 3), (int)(n - 3 + 1), (int)400, (int)0x505000FF, (int)0x505000FF);
        AbstractGui.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(tooltipX - 3), (int)(n + tooltipHeight + 2), (int)(tooltipX + tooltipWidth + 3), (int)(n + tooltipHeight + 3), (int)400, (int)1344798847, (int)1344798847);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        IRenderTypeBuffer.Impl bufferSource = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        poseStack.func_227861_a_(0.0, 0.0, 400.0);
        for (int index = 0; index < components.size(); ++index) {
            IReorderingProcessor component = components.get(index);
            if (component != null) {
                void var10_15;
                fontRenderer.func_238416_a_(component, (float)tooltipX, (float)var10_15, -1, true, matrix4f, (IRenderTypeBuffer)bufferSource, false, 0, 0xF000F0);
            }
            var10_15 += index == 0 ? 12 : 10;
        }
        bufferSource.func_228461_a_();
        poseStack.func_227865_b_();
    }
}

