/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.ItemRarity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;

public class ItemProperties {
    private int maxStackSize = 64;
    private int durability;
    private Item craftingRemainingItem;
    private Rarity rarity = Rarity.COMMON;
    private Food foodProperties;
    private boolean isFireResistant;
    final Set<ItemGroup> groups = new HashSet<ItemGroup>();

    public static ItemProperties create() {
        return new ItemProperties();
    }

    private ItemProperties() {
    }

    public ItemProperties maxStackSize(int maxStackSize) {
        if (maxStackSize < 1) {
            throw new IllegalArgumentException("Maximum stack size must be greater than zero!");
        }
        if (maxStackSize > 1 && this.durability != 0) {
            throw new RuntimeException("An item cannot have durability and be stackable!");
        }
        this.maxStackSize = maxStackSize;
        return this;
    }

    public ItemProperties durability(int durability) {
        if (this.maxStackSize != 64 && this.maxStackSize > 1) {
            throw new RuntimeException("An item cannot have durability and be stackable!");
        }
        this.durability = durability;
        this.maxStackSize = 1;
        return this;
    }

    public ItemProperties craftRemainder(Item item) {
        this.craftingRemainingItem = item;
        return this;
    }

    public ItemProperties group(ItemGroup group) {
        this.groups.add(group);
        return this;
    }

    public ItemProperties rarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemProperties rarity(ItemRarity rarity) {
        this.rarity = rarity.getUnderlying();
        return this;
    }

    public ItemProperties food(Food foodProperties) {
        this.foodProperties = foodProperties;
        return this;
    }

    public ItemProperties fireResistant() {
        this.isFireResistant = true;
        return this;
    }

    @Deprecated
    public Item.Properties toUnderlying() {
        Item.Properties properties = new Item.Properties();
        properties.func_200917_a(this.maxStackSize);
        if (this.durability != 0) {
            properties.func_200918_c(this.durability);
        }
        properties.func_200919_a(this.craftingRemainingItem);
        properties.func_208103_a(this.rarity);
        properties.func_221540_a(this.foodProperties);
        if (this.isFireResistant) {
            properties.func_234689_a_();
        }
        if (!this.groups.isEmpty()) {
            properties.func_200916_a(this.groups.iterator().next());
        }
        return properties;
    }
}

