/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.google.common.collect.Lists;
import com.supermartijn642.core.util.MappedSetView;
import com.supermartijn642.core.util.Pair;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class Registries {
    static final Map<ResourceLocation, Registry<?>> IDENTIFIER_TO_REGISTRY = new HashMap();
    static final Map<net.minecraft.util.registry.Registry<?>, Registry<?>> VANILLA_REGISTRY_MAP = new HashMap();
    static final Map<IForgeRegistry<?>, Registry<?>> FORGE_REGISTRY_MAP = new HashMap();
    static final Map<Registry<?>, List<Registry<?>>> REGISTRATION_ORDER_MAP = new HashMap();
    public static final Registry<Block> BLOCKS = Registries.forge(net.minecraft.util.registry.Registry.field_212618_g, ForgeRegistries.BLOCKS, Block.class);
    public static final Registry<Fluid> FLUIDS = Registries.forge(net.minecraft.util.registry.Registry.field_212619_h, ForgeRegistries.FLUIDS, Fluid.class);
    public static final Registry<Item> ITEMS = Registries.forge(net.minecraft.util.registry.Registry.field_212630_s, ForgeRegistries.ITEMS, Item.class);
    public static final Registry<Effect> MOB_EFFECTS = Registries.forge(net.minecraft.util.registry.Registry.field_212631_t, ForgeRegistries.POTIONS, Effect.class);
    public static final Registry<SoundEvent> SOUND_EVENTS = Registries.forge(net.minecraft.util.registry.Registry.field_212633_v, ForgeRegistries.SOUND_EVENTS, SoundEvent.class);
    public static final Registry<Potion> POTIONS = Registries.forge(net.minecraft.util.registry.Registry.field_212621_j, ForgeRegistries.POTION_TYPES, Potion.class);
    public static final Registry<Enchantment> ENCHANTMENTS = Registries.forge(net.minecraft.util.registry.Registry.field_212628_q, ForgeRegistries.ENCHANTMENTS, Enchantment.class);
    public static final Registry<EntityType<?>> ENTITY_TYPES = Registries.forge(net.minecraft.util.registry.Registry.field_212629_r, ForgeRegistries.ENTITIES, EntityType.class);
    public static final Registry<TileEntityType<?>> BLOCK_ENTITY_TYPES = Registries.forge(net.minecraft.util.registry.Registry.field_212626_o, ForgeRegistries.TILE_ENTITIES, TileEntityType.class);
    public static final Registry<ParticleType<?>> PARTICLE_TYPES = Registries.forge(net.minecraft.util.registry.Registry.field_212632_u, ForgeRegistries.PARTICLE_TYPES, ParticleType.class);
    public static final Registry<ContainerType<?>> MENU_TYPES = Registries.forge(net.minecraft.util.registry.Registry.field_218366_G, ForgeRegistries.CONTAINERS, ContainerType.class);
    public static final Registry<PaintingType> PAINTING_VARIANTS = Registries.forge(net.minecraft.util.registry.Registry.field_212620_i, ForgeRegistries.PAINTING_TYPES, PaintingType.class);
    public static final Registry<IRecipeType<?>> RECIPE_TYPES = Registries.vanilla(net.minecraft.util.registry.Registry.field_218367_H, IRecipeType.class);
    public static final Registry<IRecipeSerializer<?>> RECIPE_SERIALIZERS = Registries.forge(net.minecraft.util.registry.Registry.field_218368_I, ForgeRegistries.RECIPE_SERIALIZERS, IRecipeSerializer.class);
    public static final Registry<Attribute> ATTRIBUTES = Registries.forge(net.minecraft.util.registry.Registry.field_239692_aP_, ForgeRegistries.ATTRIBUTES, Attribute.class);
    public static final Registry<StatType<?>> STAT_TYPES = Registries.forge(net.minecraft.util.registry.Registry.field_212634_w, ForgeRegistries.STAT_TYPES, StatType.class);
    public static final Registry<IConditionSerializer<?>> RECIPE_CONDITION_SERIALIZERS = new RecipeConditionSerializerRegistry();

    private static void addRegistry(Registry<?> registry) {
        if (IDENTIFIER_TO_REGISTRY.containsKey(registry.getRegistryIdentifier())) {
            throw new RuntimeException("Duplicate registry registration for identifier '" + registry.getRegistryIdentifier() + "'!");
        }
        if (registry.hasVanillaRegistry() && VANILLA_REGISTRY_MAP.containsKey(registry.getVanillaRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + registry.getValueClass() + "'!");
        }
        if (registry.hasForgeRegistry() && FORGE_REGISTRY_MAP.containsKey(registry.getForgeRegistry())) {
            throw new RuntimeException("Duplicate registry wrapper for objects of type '" + registry.getValueClass() + "'!");
        }
        IDENTIFIER_TO_REGISTRY.put(registry.getRegistryIdentifier(), registry);
        if (registry.hasVanillaRegistry()) {
            VANILLA_REGISTRY_MAP.put(registry.getVanillaRegistry(), registry);
        }
        if (registry.hasForgeRegistry()) {
            FORGE_REGISTRY_MAP.put(registry.getForgeRegistry(), registry);
        }
    }

    @Deprecated
    public static void onRecipeConditionSerializerAdded(IConditionSerializer<?> serializer) {
        ((RecipeConditionSerializerRegistry)RECIPE_CONDITION_SERIALIZERS).onObjectAdded(serializer);
    }

    @Deprecated
    public static <T> Registry<T> fromUnderlying(net.minecraft.util.registry.Registry<T> registry) {
        return VANILLA_REGISTRY_MAP.get(registry);
    }

    @Deprecated
    public static <T extends IForgeRegistryEntry<T>> Registry<T> fromUnderlying(IForgeRegistry<T> registry) {
        return FORGE_REGISTRY_MAP.get(registry);
    }

    public static Registry<?> getRegistry(ResourceLocation identifier) {
        return IDENTIFIER_TO_REGISTRY.get(identifier);
    }

    private static <T> Registry<T> vanilla(net.minecraft.util.registry.Registry<T> registry, Class<? super T> valueClass) {
        return new VanillaRegistryWrapper(registry, valueClass);
    }

    private static <T extends IForgeRegistryEntry<T>> Registry<T> forge(net.minecraft.util.registry.Registry<T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
        return new ForgeRegistryWrapper(registry, forgeRegistry, valueClass);
    }

    static {
        REGISTRATION_ORDER_MAP.put(POTIONS, Lists.newArrayList((Object[])new Registry[]{RECIPE_TYPES}));
        REGISTRATION_ORDER_MAP.put(RECIPE_SERIALIZERS, Lists.newArrayList((Object[])new Registry[]{RECIPE_CONDITION_SERIALIZERS}));
    }

    private static class RecipeConditionSerializerRegistry
    implements Registry<IConditionSerializer<?>> {
        private static final Supplier<Map<ResourceLocation, IConditionSerializer<?>>> craftingHelperConditions;
        private static final ResourceLocation IDENTIFIER;
        private final Map<ResourceLocation, IConditionSerializer<?>> identifierToObject;
        private final Map<IConditionSerializer<?>, ResourceLocation> objectToIdentifier = new HashMap();
        private final Set<Pair<ResourceLocation, IConditionSerializer<?>>> entries = new HashSet();
        private final Class<IConditionSerializer<?>> valueClass = IConditionSerializer.class;

        private RecipeConditionSerializerRegistry() {
            this.identifierToObject = craftingHelperConditions.get();
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return IDENTIFIER;
        }

        @Override
        @Nullable
        public net.minecraft.util.registry.Registry<IConditionSerializer<?>> getVanillaRegistry() {
            return null;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return false;
        }

        @Override
        @Nullable
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, IConditionSerializer<?> object) {
            if (this.identifierToObject.containsKey(identifier)) {
                throw new RuntimeException("Duplicate registry for identifier '" + identifier + "'!");
            }
            if (this.objectToIdentifier.containsKey(object)) {
                throw new RuntimeException("Duplicate registry for object under '" + this.objectToIdentifier.get(object) + "' and '" + identifier + "'!");
            }
            if (!identifier.equals((Object)object.getID())) {
                throw new IllegalArgumentException("Condition serializer's id '" + object.getID() + "' does not match the given id '" + identifier + "'!");
            }
            CraftingHelper.register(object);
        }

        public void onObjectAdded(IConditionSerializer<?> object) {
            this.objectToIdentifier.put(object, object.getID());
            this.entries.add(Pair.of(object.getID(), object));
        }

        @Override
        public ResourceLocation getIdentifier(IConditionSerializer<?> object) {
            return this.objectToIdentifier.get(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.identifierToObject.containsKey(identifier);
        }

        @Override
        public IConditionSerializer<?> getValue(ResourceLocation identifier) {
            return this.identifierToObject.get(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return Collections.unmodifiableSet(this.identifierToObject.keySet());
        }

        @Override
        public Collection<IConditionSerializer<?>> getValues() {
            return Collections.unmodifiableCollection(this.objectToIdentifier.keySet());
        }

        @Override
        public Set<Pair<ResourceLocation, IConditionSerializer<?>>> getEntries() {
            return Collections.unmodifiableSet(this.entries);
        }

        @Override
        public Class<IConditionSerializer<?>> getValueClass() {
            return this.valueClass;
        }

        static {
            try {
                Field field = CraftingHelper.class.getDeclaredField("conditions");
                field.setAccessible(true);
                craftingHelperConditions = () -> {
                    try {
                        return (Map)field.get(null);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            IDENTIFIER = new ResourceLocation("supermartijn642corelib", "resource_conditions");
        }
    }

    private static class ForgeRegistryWrapper<T extends IForgeRegistryEntry<T>>
    implements Registry<T> {
        private final net.minecraft.util.registry.Registry<T> registry;
        private final IForgeRegistry<T> forgeRegistry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private ForgeRegistryWrapper(net.minecraft.util.registry.Registry<T> registry, IForgeRegistry<T> forgeRegistry, Class<? super T> valueClass) {
            this.registry = registry;
            this.forgeRegistry = forgeRegistry;
            this.identifier = forgeRegistry.getRegistryName();
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        @Deprecated
        public net.minecraft.util.registry.Registry<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return this.registry != null;
        }

        @Override
        @Nullable
        @Deprecated
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return this.forgeRegistry;
        }

        @Override
        public boolean hasForgeRegistry() {
            return true;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            object.setRegistryName(identifier);
            this.forgeRegistry.register(object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.forgeRegistry.getKey(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.forgeRegistry.containsKey(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.forgeRegistry.getValue(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.forgeRegistry.getKeys();
        }

        @Override
        public Collection<T> getValues() {
            return this.forgeRegistry.getValues();
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.forgeRegistry.getEntries(), entry -> Pair.of(((RegistryKey)entry.getKey()).func_240901_a_(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.forgeRegistry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }

    private static class VanillaRegistryWrapper<T>
    implements Registry<T> {
        private final net.minecraft.util.registry.Registry<T> registry;
        private final ResourceLocation identifier;
        private final Class<T> valueClass;

        private VanillaRegistryWrapper(net.minecraft.util.registry.Registry<T> registry, Class<? super T> valueClass) {
            this.registry = registry;
            this.identifier = registry.func_243578_f().func_240901_a_();
            this.valueClass = valueClass;
            Registries.addRegistry(this);
        }

        @Override
        public ResourceLocation getRegistryIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        @Deprecated
        public net.minecraft.util.registry.Registry<T> getVanillaRegistry() {
            return this.registry;
        }

        @Override
        public boolean hasVanillaRegistry() {
            return true;
        }

        @Override
        @Nullable
        @Deprecated
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry() {
            return null;
        }

        @Override
        public boolean hasForgeRegistry() {
            return false;
        }

        @Override
        public void register(ResourceLocation identifier, T object) {
            net.minecraft.util.registry.Registry.func_218322_a(this.registry, (ResourceLocation)identifier, object);
        }

        @Override
        public ResourceLocation getIdentifier(T object) {
            return this.registry.func_177774_c(object);
        }

        @Override
        public boolean hasIdentifier(ResourceLocation identifier) {
            return this.registry.func_212607_c(identifier);
        }

        @Override
        public T getValue(ResourceLocation identifier) {
            return (T)this.registry.func_82594_a(identifier);
        }

        @Override
        public Set<ResourceLocation> getIdentifiers() {
            return this.registry.func_148742_b();
        }

        @Override
        public Collection<T> getValues() {
            return MappedSetView.map(this.registry.func_239659_c_(), Map.Entry::getValue);
        }

        @Override
        public Set<Pair<ResourceLocation, T>> getEntries() {
            return MappedSetView.map(this.registry.func_239659_c_(), entry -> Pair.of(((RegistryKey)entry.getKey()).func_240901_a_(), entry.getValue()));
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public int hashCode() {
            int result = this.registry.hashCode();
            result = 31 * result + this.valueClass.hashCode();
            return result;
        }
    }

    public static interface Registry<T> {
        public ResourceLocation getRegistryIdentifier();

        @Nullable
        public net.minecraft.util.registry.Registry<T> getVanillaRegistry();

        public boolean hasVanillaRegistry();

        @Nullable
        public <X extends IForgeRegistryEntry<X>> IForgeRegistry<X> getForgeRegistry();

        public boolean hasForgeRegistry();

        public void register(ResourceLocation var1, T var2);

        public ResourceLocation getIdentifier(T var1);

        public boolean hasIdentifier(ResourceLocation var1);

        public T getValue(ResourceLocation var1);

        public Set<ResourceLocation> getIdentifiers();

        public Collection<T> getValues();

        public Set<Pair<ResourceLocation, T>> getEntries();

        public Class<T> getValueClass();
    }
}

