/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.supplementaries.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.LOD;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.TextUtil;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.RequestMapDataFromServerPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.AbstractMapItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class NoticeBoardBlockTileRenderer
extends TileEntityRenderer<NoticeBoardBlockTile> {
    protected final ItemRenderer itemRenderer;
    protected final MapItemRenderer mapRenderer;

    public NoticeBoardBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Minecraft minecraft = Minecraft.func_71410_x();
        this.itemRenderer = minecraft.func_175599_af();
        this.mapRenderer = minecraft.field_71460_t.func_147701_i();
    }

    public int getFrontLight(World world, BlockPos pos, Direction dir) {
        return WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)pos.func_177972_a(dir));
    }

    public boolean getAxis(Direction dir) {
        return dir == Direction.NORTH || dir == Direction.SOUTH;
    }

    public void render(NoticeBoardBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.shouldSkipTileRenderer()) {
            BlockPos pos;
            ItemStack stack = tile.getDisplayedItem();
            if (stack.func_190926_b()) {
                return;
            }
            World world = tile.func_145831_w();
            Direction dir = tile.getDirection();
            float yaw = -dir.func_185119_l();
            Vector3d cameraPos = this.field_228858_b_.field_217666_g.func_216785_c();
            if (LOD.isOutOfFocus(cameraPos, pos = tile.func_174877_v(), yaw)) {
                return;
            }
            int frontLight = this.getFrontLight(world, pos, dir);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Const.rot((int)yaw));
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.5);
            MapData mapdata = FilledMapItem.func_195950_a((ItemStack)stack, (World)world);
            if (stack.func_77973_b() instanceof AbstractMapItem) {
                if (mapdata != null) {
                    matrixStackIn.func_227860_a_();
                    matrixStackIn.func_227861_a_(0.0, 0.0, 0.008);
                    matrixStackIn.func_227862_a_(0.0078125f, -0.0078125f, -0.0078125f);
                    matrixStackIn.func_227861_a_(-64.0, -64.0, 0.0);
                    this.mapRenderer.func_228086_a_(matrixStackIn, bufferIn, mapdata, true, frontLight);
                    matrixStackIn.func_227865_b_();
                } else {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    NetworkHandler.INSTANCE.sendToServer((Object)new RequestMapDataFromServerPacket(tile.func_174877_v(), player.func_110124_au()));
                }
                matrixStackIn.func_227865_b_();
                return;
            }
            String page = tile.getText();
            if (page != null && !page.equals("")) {
                int scalingfactor;
                List tempPageLines;
                LOD lod = new LOD(cameraPos, pos);
                if (!lod.isNearMed()) {
                    matrixStackIn.func_227865_b_();
                    return;
                }
                FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, 0.5, 0.008);
                float d0 = this.getAxis(dir) ? 0.56f : 0.42000002f;
                if (CommonUtil.FESTIVITY.isAprilsFool()) {
                    TextUtil.renderBeeMovie(matrixStackIn, bufferIn, frontLight, fontrenderer, d0);
                    matrixStackIn.func_227865_b_();
                    matrixStackIn.func_227865_b_();
                    return;
                }
                String bookName = tile.func_70301_a(0).func_200301_q().getString().toLowerCase(Locale.ROOT);
                if (bookName.equals("credits")) {
                    TextUtil.renderCredits(matrixStackIn, bufferIn, frontLight, fontrenderer, d0);
                    matrixStackIn.func_227865_b_();
                    matrixStackIn.func_227865_b_();
                    return;
                }
                int i = tile.getTextColor().func_218388_g();
                int r = (int)((double)NativeImage.func_227791_b_((int)i) * (double)d0);
                int g = (int)((double)NativeImage.func_227793_c_((int)i) * (double)d0);
                int b = (int)((double)NativeImage.func_227795_d_((int)i) * (double)d0);
                int i1 = NativeImage.func_227787_a_((int)0, (int)b, (int)g, (int)r);
                if (tile.getFlag()) {
                    float maxlines;
                    ITextProperties txt = TextUtil.iGetPageText(page);
                    int width = fontrenderer.func_238414_a_(txt);
                    float bordery = 0.125f;
                    float borderx = 0.1875f;
                    float lx = 1.0f - 2.0f * borderx;
                    float ly = 1.0f - 2.0f * bordery;
                    do {
                        scalingfactor = MathHelper.func_76141_d((float)MathHelper.func_76129_c((float)((float)width * 8.0f / (lx * ly))));
                        tempPageLines = fontrenderer.func_238425_b_(txt, MathHelper.func_76141_d((float)(lx * (float)scalingfactor)));
                        maxlines = ly * (float)scalingfactor / 8.0f;
                        ++width;
                    } while (maxlines < (float)tempPageLines.size());
                    tile.setFontScale(scalingfactor);
                    tile.setCachedPageLines(tempPageLines);
                } else {
                    tempPageLines = tile.getCachedPageLines();
                    scalingfactor = tile.getFontScale();
                }
                float scale = 1.0f / (float)scalingfactor;
                matrixStackIn.func_227862_a_(scale, -scale, scale);
                int numberoflin = tempPageLines.size();
                for (int lin = 0; lin < numberoflin; ++lin) {
                    IReorderingProcessor str = tempPageLines.get(lin);
                    float dx = (float)(-fontrenderer.func_243245_a(str) / 2) + 0.5f;
                    float dy = (float)(scalingfactor - 8 * numberoflin) / 2.0f + 0.5f;
                    if (!bookName.equals("missingno")) {
                        fontrenderer.func_238416_a_(str, dx, dy + (float)(8 * lin), i1, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, frontLight);
                        continue;
                    }
                    fontrenderer.func_228079_a_("\u00a7ka", dx, dy + (float)(8 * lin), i1, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, frontLight);
                }
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227865_b_();
                return;
            }
            if (!stack.func_190926_b()) {
                RenderMaterial rendermaterial = tile.getCachedPattern();
                if (rendermaterial != null) {
                    IVertexBuilder builder = rendermaterial.func_229311_a_(bufferIn, RenderType::func_228650_h_);
                    int i = tile.getTextColor().func_218388_g();
                    float b = (float)NativeImage.func_227791_b_((int)i) / 255.0f;
                    float g = (float)NativeImage.func_227793_c_((int)i) / 255.0f;
                    float r = (float)NativeImage.func_227795_d_((int)i) / 255.0f;
                    int lu = frontLight & 0xFFFF;
                    int lv = frontLight >> 16 & 0xFFFF;
                    RendererUtil.addQuadSide(builder, matrixStackIn, -0.4375f, -0.4375f, 0.008f, 0.4375f, 0.4375f, 0.008f, 0.15625f, 0.0625f, 0.59375f, 0.9375f, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, rendermaterial.func_229314_c_());
                } else {
                    IBakedModel ibakedmodel = this.itemRenderer.func_184393_a(stack, world, null);
                    matrixStackIn.func_227861_a_(0.0, 0.0, 0.015675);
                    matrixStackIn.func_227862_a_(-0.5f, 0.5f, -0.5f);
                    this.itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, frontLight, combinedOverlayIn, ibakedmodel);
                }
                matrixStackIn.func_227865_b_();
                return;
            }
            matrixStackIn.func_227865_b_();
        }
    }
}

