/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.entities.ShardProjectileEntity;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class AmethystArrowEntity
extends AbstractArrowEntity {
    private final int maxSplashDamage = 6;

    public AmethystArrowEntity(EntityType<? extends AmethystArrowEntity> type, World world) {
        super(type, world);
    }

    public AmethystArrowEntity(World worldIn, LivingEntity throwerIn) {
        super((EntityType)ModRegistry.AMETHYST_ARROW.get(), throwerIn, worldIn);
        this.func_70239_b(1.0);
    }

    public AmethystArrowEntity(World worldIn, double x, double y, double z) {
        super((EntityType)ModRegistry.AMETHYST_ARROW.get(), x, y, z, worldIn);
        this.func_70239_b(1.0);
    }

    public AmethystArrowEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType)ModRegistry.AMETHYST_ARROW.get(), world);
        this.func_70239_b(1.0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    public void func_70239_b(double p_70239_1_) {
        super.func_70239_b(p_70239_1_);
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        boolean flag = this.func_203047_q();
        Vector3d movement = this.func_213322_ci();
        double velX = movement.field_72450_a;
        double velY = movement.field_72448_b;
        double velZ = movement.field_72449_c;
        float horizontalVel = MathHelper.func_76133_a((double)AmethystArrowEntity.func_213296_b((Vector3d)movement));
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)velX, (double)velZ) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)velY, (double)horizontalVel) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!((blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) || flag || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.field_70254_i = true;
                break;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.field_70254_i && !flag) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_225516_i_();
            }
            ++this.field_184552_b;
        } else {
            Vector3d newPos;
            this.field_184552_b = 0;
            Vector3d pos = this.func_213303_ch();
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(pos, newPos = pos.func_178787_e(movement), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                newPos = raytraceresult.func_216347_e();
            }
            if (this.func_70241_g()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_() + velX * (double)i / 4.0, this.func_226278_cu_() + velY * (double)i / 4.0, this.func_226281_cx_() + velZ * (double)i / 4.0, -velX, -velY + 0.2, -velZ);
                }
            }
            double posX = newPos.field_72450_a;
            double posY = newPos.field_72448_b;
            double posZ = newPos.field_72449_c;
            this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-velX), (double)(-velZ)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)velX, (double)velZ) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)velY, (double)horizontalVel) * 57.2957763671875);
            this.field_70125_A = AmethystArrowEntity.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = AmethystArrowEntity.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            float deceleration = 0.99f;
            float gravity = 0.05f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, posX - velX * 0.25, posY - velY * 0.25, posZ - velZ * 0.25, velX, velY, velZ);
                }
                deceleration = this.func_203044_p();
            }
            this.func_213317_d(movement.func_186678_a((double)deceleration));
            if (!this.func_189652_ae() && !flag) {
                this.func_213293_j(velX, velY - (double)gravity, velZ);
            }
            this.func_70107_b(posX, posY, posZ);
            this.func_145775_I();
            while (!this.field_70128_L) {
                EntityRayTraceResult entityraytraceresult = this.func_213866_a(pos, newPos);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity2 = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.func_234616_v_();
                    if (entity2 instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity2)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
                    this.func_70227_a((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.func_213874_s() <= 0) break;
                raytraceresult = null;
            }
        }
    }

    protected void func_70227_a(RayTraceResult hit) {
        super.func_70227_a(hit);
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        if (this.field_70170_p.field_72995_K) {
            for (int l2 = 0; l2 < 8; ++l2) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)ModRegistry.AMETHYST_ARROW_ITEM.get())), x, y, z, this.field_70146_Z.nextGaussian() * 0.1, this.field_70146_Z.nextDouble() * 0.15, this.field_70146_Z.nextGaussian() * 0.1);
            }
        } else {
            List<Vector3d> directions = this.getShootVectors(this.field_70146_Z, 0.0f);
            for (Vector3d vec : directions) {
                Entity target = null;
                Direction dir = Direction.UP;
                if (hit.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    target = ((EntityRayTraceResult)hit).func_216348_a();
                } else if (hit.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    dir = ((BlockRayTraceResult)hit).func_216354_b();
                }
                vec = vec.func_186678_a((double)0.35f);
                vec = this.rotateVector(vec, dir);
                ShardProjectileEntity shard = new ShardProjectileEntity(this.field_70170_p, (LivingEntity)this.func_234616_v_(), x + vec.field_72450_a, y + vec.field_72448_b + 0.25, vec.field_72449_c + z, vec, target);
                this.field_70170_p.func_217376_c((Entity)shard);
            }
            this.func_184185_a(SoundEvents.field_193777_bb, 1.1f, 1.9f);
        }
        this.func_70106_y();
    }

    public List<Vector3d> getShootVectors(Random random, float uncertainty) {
        ArrayList<Vector3d> vectors = new ArrayList<Vector3d>();
        float turnFraction = (1.0f + MathHelper.func_76129_c((float)5.0f)) / 2.0f;
        int numPoints = 17;
        double fullness = 0.8;
        for (int i = 1; i <= numPoints; ++i) {
            float dst = (float)i / (float)numPoints;
            float inclination = (random.nextFloat() - 0.5f) * uncertainty + (float)Math.acos(1.0 - fullness * (double)dst);
            float azimuth = (float)((double)((random.nextFloat() - 0.5f) * uncertainty) + Math.PI * 2 * (double)(random.nextFloat() + turnFraction * (float)i));
            double x = Math.sin(inclination) * Math.cos(azimuth);
            double z = Math.sin(inclination) * Math.sin(azimuth);
            double y = Math.cos(inclination);
            Vector3d vec = new Vector3d(x, y, z);
            if (i == 1) {
                vec = vec.func_72441_c(0.0, 1.0, 0.0);
                vec = vec.func_186678_a(0.5);
            }
            vectors.add(vec);
        }
        return vectors;
    }

    private Vector3d rotateVector(Vector3d v, Direction dir) {
        switch (dir) {
            default: {
                return v;
            }
            case DOWN: {
                return v.func_216372_d(0.0, -1.0, 0.0);
            }
            case NORTH: {
                return new Vector3d(v.field_72449_c, v.field_72450_a, -v.field_72448_b);
            }
            case SOUTH: {
                return new Vector3d(v.field_72449_c, v.field_72450_a, v.field_72448_b);
            }
            case WEST: {
                return new Vector3d(-v.field_72448_b, v.field_72449_c, v.field_72450_a);
            }
            case EAST: 
        }
        return new Vector3d(v.field_72448_b, v.field_72449_c, v.field_72450_a);
    }

    private void applySplash(@Nullable Entity target) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0;
                if (target != null) {
                    double x = (this.func_226277_ct_() + target.func_226277_ct_()) / 2.0 - livingentity.func_226277_ct_();
                    double y = (this.func_226278_cu_() + target.func_226278_cu_()) / 2.0 - livingentity.func_226278_cu_();
                    double z = (this.func_226281_cx_() + target.func_226281_cx_()) / 2.0 - livingentity.func_226281_cx_();
                    d0 = x * x + y * y + z * z;
                } else {
                    d0 = this.func_70068_e((Entity)livingentity);
                }
                if (!(d0 < 16.0)) continue;
                double power = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == target) {
                    power = 1.0;
                }
                int damage = (int)(power * 6.0 + 0.5);
                livingentity.func_70097_a(CommonUtil.AMETHYST_SHARD_DAMAGE, (float)damage);
            }
        }
    }
}

