/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import net.mehvahdjukaar.supplementaries.common.VectorUtils;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.entities.ImprovedProjectileEntity;
import net.mehvahdjukaar.supplementaries.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class SlingshotProjectileEntity
extends ImprovedProjectileEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> ID_LOYALTY = EntityDataManager.func_187226_a(SlingshotProjectileEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public int clientSideReturnTridentTickCount;
    private float xRotInc;
    private float yRotInc;
    private float particleCooldown = 0.0f;
    public Lazy<Integer> light = Lazy.of(() -> {
        Item item2 = this.func_184543_l().func_77973_b();
        if (item2 instanceof BlockItem) {
            Block b = ((BlockItem)item2).func_179223_d();
            return b.getBlock().getLightValue(b.func_176223_P(), (IBlockReader)this.field_70170_p, this.func_233580_cy_());
        }
        return 0;
    });

    public SlingshotProjectileEntity(LivingEntity thrower, World world, ItemStack item2, ItemStack throwerStack) {
        super((EntityType<? extends ProjectileItemEntity>)((EntityType)ModRegistry.SLINGSHOT_PROJECTILE.get()), thrower, world);
        this.func_213884_b(item2);
        this.field_70180_af.func_187227_b(ID_LOYALTY, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)throwerStack)));
        this.func_189654_d(EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get()), (ItemStack)throwerStack) != 0);
        this.maxAge = 500;
        this.yRotInc = (float)(this.field_70146_Z.nextBoolean() ? 1 : -1) * (float)(4.0 * this.field_70146_Z.nextGaussian() + 7.0);
        this.xRotInc = (float)(this.field_70146_Z.nextBoolean() ? 1 : -1) * (float)(4.0 * this.field_70146_Z.nextGaussian() + 7.0);
        this.field_70125_A = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public SlingshotProjectileEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<SlingshotProjectileEntity>)((EntityType)ModRegistry.SLINGSHOT_PROJECTILE.get()), world);
    }

    public SlingshotProjectileEntity(EntityType<SlingshotProjectileEntity> type, World world) {
        super(type, world);
        this.maxAge = 500;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ID_LOYALTY, (Object)0);
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.field_70180_af.func_187227_b(ID_LOYALTY, (Object)tag.func_74771_c("Loyalty"));
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a("Loyalty", ((Byte)this.field_70180_af.func_187225_a(ID_LOYALTY)).byteValue());
    }

    public void setLoyalty(ItemStack stack) {
        this.field_70180_af.func_187227_b(ID_LOYALTY, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)stack)));
    }

    protected Item func_213885_i() {
        return Items.field_221574_b;
    }

    protected void func_213868_a(EntityRayTraceResult entityRayTraceResult) {
        super.func_213868_a(entityRayTraceResult);
        Entity entity2 = entityRayTraceResult.func_216348_a();
        if (entity2 instanceof EndermanEntity) {
            Block block2;
            EndermanEntity enderman = (EndermanEntity)entity2;
            Item item2 = this.func_184543_l().func_77973_b();
            if (item2 instanceof BlockItem && ((block2 = ((BlockItem)item2).func_179223_d()).func_203417_a((ITag)BlockTags.field_201151_l) || ServerConfigs.cached.UNRESTRICTED_SLINGSHOT) && enderman.func_195405_dq() == null) {
                enderman.func_195406_b(block2.func_176223_P());
                this.func_70106_y();
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult hit) {
        super.func_230299_a_(hit);
        if (this.touchedGround) {
            return;
        }
        Entity owner = this.func_234616_v_();
        boolean success = false;
        if (owner instanceof PlayerEntity && ((PlayerEntity)owner).field_71075_bZ.field_75099_e) {
            ItemStack stack = this.func_184543_l();
            Item item2 = stack.func_77973_b();
            PlayerInteractEvent.RightClickBlock blockPlaceEvent = new PlayerInteractEvent.RightClickBlock((PlayerEntity)owner, Hand.MAIN_HAND, hit.func_216350_a(), hit);
            ItemsOverrideHandler.tryPerformOverride(blockPlaceEvent, stack, true);
            if (blockPlaceEvent.isCanceled() && blockPlaceEvent.getCancellationResult().func_226246_a_()) {
                success = true;
            }
            if (!success && item2 instanceof BlockItem) {
                BlockItemUseContext ctx = new BlockItemUseContext(this.field_70170_p, (PlayerEntity)owner, Hand.MAIN_HAND, this.func_184543_l(), hit);
                success = ((BlockItem)item2).func_195942_a(ctx).func_226246_a_();
            }
            if (success) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.isNoPhysics()) {
            byte i = (Byte)this.field_70180_af.func_187225_a(ID_LOYALTY);
            Entity owner = this.func_234616_v_();
            if (i > 0 && this.isAcceptableReturnOwner(owner)) {
                Vector3d vector3d = new Vector3d(owner.func_226277_ct_() - this.func_226277_ct_(), owner.func_226280_cw_() - this.func_226278_cu_(), owner.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.func_70071_h_();
    }

    private boolean isAcceptableReturnOwner(Entity owner) {
        if (owner != null && owner.func_70089_S()) {
            return !(owner instanceof ServerPlayerEntity) || !owner.func_175149_v();
        }
        return false;
    }

    public void func_70100_b_(PlayerEntity playerEntity) {
        if (this.isNoPhysics() || this.touchedGround) {
            boolean success;
            boolean bl = success = playerEntity.field_71075_bZ.field_75098_d || playerEntity.field_71071_by.func_70441_a(this.func_184543_l());
            if (!this.field_70170_p.field_72995_K) {
                if (!success) {
                    this.func_70099_a(this.func_184543_l(), 0.1f);
                }
            } else {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 1.4f + 2.0f, false);
            }
            this.func_70106_y();
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        if (this.func_189652_ae() && this.func_213322_ci().func_189985_c() < 0.005) {
            return true;
        }
        return super.hasReachedEndOfLife() && !this.isNoPhysics();
    }

    @Override
    public void reachedEndOfLife() {
        if ((Byte)this.field_70180_af.func_187225_a(ID_LOYALTY) != 0 && this.isAcceptableReturnOwner(this.func_234616_v_())) {
            this.setNoPhysics(true);
            this.groundTime = 0;
        } else {
            this.func_70099_a(this.func_184543_l(), 0.1f);
            super.reachedEndOfLife();
        }
    }

    protected void func_234617_x_() {
        if (!this.isNoPhysics()) {
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.field_70125_A += this.xRotInc;
            this.field_70177_z += this.yRotInc;
            this.particleCooldown += 1.0f;
        } else {
            super.func_234617_x_();
        }
    }

    @Override
    public void spawnTrailParticles(Vector3d currentPos, Vector3d newPos) {
        if (!this.isNoPhysics()) {
            double d = this.func_213322_ci().func_72433_c();
            if (this.field_70173_aa > 1 && d * (double)this.field_70173_aa > 1.5) {
                if (this.func_189652_ae()) {
                    Vector3d rot = new Vector3d(0.325, 0.0, 0.0).func_178785_b((float)this.field_70173_aa * 0.32f);
                    Vector3d movement = this.func_213322_ci();
                    Vector3d offset = VectorUtils.changeBasisN(movement, rot);
                    double px = newPos.field_72450_a + offset.field_72450_a;
                    double py = newPos.field_72448_b + offset.field_72448_b;
                    double pz = newPos.field_72449_c + offset.field_72449_c;
                    movement = movement.func_186678_a(0.25);
                    this.field_70170_p.func_195594_a((IParticleData)ModRegistry.STASIS_PARTICLE.get(), px, py, pz, movement.field_72450_a, movement.field_72448_b, movement.field_72449_c);
                } else {
                    double interval = 4.0 / (d * 0.95 + 0.05);
                    if ((double)this.particleCooldown > interval) {
                        this.particleCooldown = (float)((double)this.particleCooldown - interval);
                        double x = currentPos.field_72450_a;
                        double y = currentPos.field_72448_b;
                        double z = currentPos.field_72449_c;
                        this.field_70170_p.func_195594_a((IParticleData)ModRegistry.SLINGSHOT_PARTICLE.get(), x, y, z, 0.0, 0.01, 0.0);
                    }
                }
            }
        }
    }

    @Override
    protected float getDeceleration() {
        return this.func_189652_ae() ? ServerConfigs.cached.SLINGSHOT_DECELERATION : super.getDeceleration();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        Entity entity2 = this.func_234616_v_();
        int id = -1;
        if (entity2 != null) {
            id = entity2.func_145782_y();
        }
        buffer.writeInt(id);
        buffer.writeFloat(this.xRotInc);
        buffer.writeFloat(this.yRotInc);
        buffer.writeFloat(this.field_70125_A);
        buffer.writeFloat(this.field_70177_z);
    }

    public void readSpawnData(PacketBuffer buffer) {
        int id = buffer.readInt();
        if (id != -1) {
            this.func_212361_a(this.field_70170_p.func_73045_a(id));
        }
        this.xRotInc = buffer.readFloat();
        this.yRotInc = buffer.readFloat();
        this.field_70125_A = buffer.readFloat();
        this.field_70177_z = buffer.readFloat();
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }
}

