/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.events;

import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.RakedGravelBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.PicklePlayer;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.quark.QuarkPlugin;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.entities.goals.EatFodderGoal;
import net.mehvahdjukaar.supplementaries.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.items.CandyItem;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SendLoginMessagePacket;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChainBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerEvents {
    private static final ResourceLocation ANTIQUE_INK = new ResourceLocation("supplementaries", "antique_ink");

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlockHigh(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player;
        if (ServerConfigs.cached.WALL_LANTERN_HIGH_PRIORITY && !(player = event.getPlayer()).func_175149_v()) {
            ItemsOverrideHandler.tryHighPriorityOverride(event, event.getItemStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_175149_v()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (ItemsOverrideHandler.tryPerformOverride(event, stack, false)) {
            return;
        }
        if (!player.func_225608_bj_()) {
            Hand hand = event.getHand();
            Item i = stack.func_77973_b();
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState blockstate = world.func_180495_p(pos);
            if (ServerConfigs.cached.DIRECTIONAL_CAKE && blockstate == Blocks.field_150414_aQ.func_176223_P() && (!ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT || i != Items.field_222070_lD)) {
                BlockState newState = ((Block)ModRegistry.DIRECTIONAL_CAKE.get()).func_176223_P();
                world.func_180501_a(pos, newState, 4);
                BlockRayTraceResult raytrace = new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), event.getFace(), pos, false);
                event.setCanceled(true);
                event.setCancellationResult(newState.func_227031_a_(world, player, hand, raytrace));
                return;
            }
            if (stack.func_190926_b() && hand == Hand.MAIN_HAND && ServerConfigs.cached.BELL_CHAIN && RopeBlock.findAndRingBell(world, pos, player, 0, s -> s.func_177230_c() instanceof ChainBlock && s.func_177229_b((Property)ChainBlock.field_176298_M) == Direction.Axis.Y)) {
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity playerIn = event.getPlayer();
        ItemStack itemstack = playerIn.func_184586_b(event.getHand());
        Item i = itemstack.func_77973_b();
        World worldIn = event.getWorld();
        if (ServerConfigs.cached.THROWABLE_BRICKS_ENABLED && CommonUtil.isBrick(i)) {
            worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                ThrowableBrickEntity brickEntity = new ThrowableBrickEntity(worldIn, (LivingEntity)playerIn);
                brickEntity.func_213884_b(itemstack);
                float pow = 0.7f;
                brickEntity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f * pow, 1.0f * pow);
                worldIn.func_217376_c((Entity)brickEntity);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K));
            return;
        }
        if (worldIn.field_72995_K && ClientConfigs.cached.CLOCK_CLICK && i == Items.field_151113_aN) {
            ClockBlock.displayCurrentHour(worldIn, playerIn);
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)true));
        }
    }

    @SubscribeEvent
    public static void onHoeUsed(UseHoeEvent event) {
        BlockState raked;
        ItemUseContext context = event.getContext();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (ServerConfigs.cached.RAKED_GRAVEL && world.func_180495_p(pos).func_203425_a(Blocks.field_150351_n) && (raked = ((Block)ModRegistry.RAKED_GRAVEL.get()).func_176223_P()).func_196955_c((IWorldReader)world, pos)) {
            world.func_180501_a(pos, RakedGravelBlock.getConnectedState(raked, world, pos, context.func_195992_f()), 11);
            world.func_184133_a(context.func_195999_j(), pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onAttachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (CompatHandler.quark) {
            QuarkPlugin.attachCapabilities(event);
        }
    }

    @SubscribeEvent
    public static void onAttachTileCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            CandyItem.checkSweetTooth(event.player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        EntityType type;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AnimalEntity && ModTags.EATS_FODDER.func_230235_a_((Object)(type = event.getEntity().func_200600_R()))) {
            AnimalEntity animal = (AnimalEntity)entity2;
            animal.field_70714_bg.func_75776_a(3, (Goal)new EatFodderGoal(animal, 1.0, 8, 2, 30));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        try {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SendLoginMessagePacket());
        }
        catch (Exception exception) {
            Supplementaries.LOGGER.warn("failed to end login message: " + exception);
        }
        PicklePlayer.PickleData.onPlayerLogin(event.getPlayer());
    }
}

