/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import java.util.Optional;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.entities.RedMerchantEntity;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.IServerWorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class SpawnRedMerchantMixin {
    @Shadow
    private int field_221249_d;
    @Shadow
    private int field_221248_c;
    @Final
    @Shadow
    private Random field_221246_a;
    @Final
    @Shadow
    private IServerWorldInfo field_234559_b_;
    private int redSpawnDelay = 0;

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(ServerWorld p_230253_1_, boolean p_230253_2_, boolean p_230253_3_, CallbackInfoReturnable<Integer> cir) {
        if (this.redSpawnDelay > 0) {
            --this.redSpawnDelay;
        }
    }

    @Inject(method={"spawn"}, at={@At(value="RETURN")}, cancellable=true)
    public void spawn(ServerWorld world, CallbackInfoReturnable<Boolean> cir) {
        RedMerchantEntity trader;
        PointOfInterestManager pointofinterestmanager;
        Optional optional;
        BlockPos targetPos;
        BlockPos spawnPos;
        BlockPos blockpos;
        ServerPlayerEntity playerentity;
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.redSpawnDelay == 0 && (playerentity = world.func_217472_l_()) != null && this.field_221246_a.nextInt(9) == 0 && this.calculateNormalizeDifficulty(world, blockpos = playerentity.func_233580_cy_()) > this.field_221246_a.nextFloat() * 90.0f && (spawnPos = this.func_234561_a_((IWorldReader)world, targetPos = (optional = (pointofinterestmanager = world.func_217443_B()).func_219127_a(PointOfInterestType.field_221070_r.func_221045_c(), p_221241_0_ -> true, blockpos, 48, PointOfInterestManager.Status.ANY)).orElse(blockpos), 48)) != null && this.func_234560_a_((IBlockReader)world, spawnPos) && !world.func_242406_i(spawnPos).equals(Optional.of(Biomes.field_185440_P)) && (trader = (RedMerchantEntity)((EntityType)ModRegistry.RED_MERCHANT_TYPE.get()).func_220342_a(world, null, null, null, spawnPos, SpawnReason.EVENT, false, false)) != null) {
            this.field_234559_b_.func_230394_a_(trader.func_110124_au());
            int lifetime = 25000;
            trader.setDespawnDelay(lifetime);
            trader.setWanderTarget(targetPos);
            trader.func_213390_a(targetPos, 16);
            this.redSpawnDelay = lifetime;
        }
    }

    private float calculateNormalizeDifficulty(ServerWorld world, BlockPos pos) {
        float scale;
        float dragon = 1.0f;
        CompoundNBT tag = world.func_73046_m().func_240793_aU_().func_230402_B_();
        if (tag.func_150297_b("DragonKilled", 99) && tag.func_74767_n("DragonKilled")) {
            dragon = 1.25f;
        }
        long i = 0L;
        float f = 0.0f;
        if (world.func_175667_e(pos)) {
            f = world.func_242413_ae();
            i = world.func_175726_f(pos).func_177416_w();
        }
        DifficultyInstance instance = new DifficultyInstance(Difficulty.NORMAL, world.func_72820_D(), i, f);
        float diff = instance.func_180168_b();
        diff = (float)((double)diff - 1.5);
        diff *= 4.0f;
        switch (world.func_175659_aa()) {
            default: {
                scale = 1.0f;
                break;
            }
            case EASY: {
                scale = 1.25f;
                break;
            }
            case NORMAL: {
                scale = 1.5f;
                break;
            }
            case HARD: {
                scale = 1.75f;
            }
        }
        diff *= scale;
        return diff *= dragon;
    }

    @Shadow
    protected abstract boolean func_234560_a_(IBlockReader var1, BlockPos var2);

    @Shadow
    protected abstract BlockPos func_234561_a_(IWorldReader var1, BlockPos var2, int var3);
}

