/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BedHandlingModule
extends AbstractBuildingModule
implements IModuleWithExternalBlocks,
IPersistentModule,
IBuildingEventsModule {
    @NotNull
    private final Set<BlockPos> bedList = new HashSet<BlockPos>();

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        ListNBT bedTagList = compound.func_150295_c("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundNBT bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = NBTUtil.func_186861_c((CompoundNBT)bedCompound);
            this.bedList.add(bedPos);
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        if (!this.bedList.isEmpty()) {
            @NotNull ListNBT bedTagList = new ListNBT();
            for (BlockPos pos : this.bedList) {
                bedTagList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_218657_a("beds", (INBT)bedTagList);
        }
    }

    @Override
    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        BlockPos registrationPosition = pos;
        if (blockState.func_177230_c() instanceof BedBlock) {
            if (blockState.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.FOOT) {
                registrationPosition = registrationPosition.func_177972_a((Direction)blockState.func_177229_b((Property)BedBlock.field_185512_D));
            }
            this.bedList.add(registrationPosition);
        }
    }

    @Override
    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    @Override
    public void onWakeUp() {
        World world = this.building.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            BlockState state;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((state = world.func_180495_p(pos)).func_177230_c() instanceof BedBlock) || !((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue() || !((BedPart)state.func_177229_b((Property)BedBlock.field_176472_a)).equals((Object)BedPart.HEAD)) continue;
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

