/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.expedition;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpeditionLog {
    private static final String TAG_STATUS = "status";
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private static final String TAG_STATS = "stats";
    private static final String TAG_EQUIPMENT = "equip";
    private static final String TAG_MOBS = "mobs";
    private static final String TAG_TYPE = "type";
    private static final String TAG_COUNT = "count";
    private static final String TAG_LOOT = "loot";
    private Status status = Status.NONE;
    private int id;
    private String name;
    private Map<StatType, Double> stats = new HashMap<StatType, Double>();
    private List<ItemStack> equipment = new ArrayList<ItemStack>();
    private Map<EntityType<?>, Integer> mobs = new HashMap();
    private Map<ItemStorage, ItemStorage> loot = new HashMap<ItemStorage, ItemStorage>();

    public void reset() {
        this.status = Status.NONE;
        this.id = 0;
        this.name = null;
        this.stats.clear();
        this.equipment = Collections.emptyList();
        this.mobs.clear();
        this.loot.clear();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public double getStat(StatType stat) {
        return this.stats.getOrDefault((Object)stat, 0.0);
    }

    public void setCitizen(@Nullable AbstractEntityCitizen citizen) {
        if (citizen == null) {
            this.id = 0;
            this.name = null;
            this.stats.clear();
        } else {
            this.id = citizen.func_145782_y();
            this.name = citizen.getCitizenData().getName();
            this.stats.put(StatType.HEALTH, Double.valueOf(citizen.func_110143_aJ()));
            this.stats.put(StatType.SATURATION, citizen.getCitizenData().getSaturation());
        }
    }

    public void setKilled() {
        this.id = 0;
        this.status = Status.KILLED;
    }

    public List<ItemStack> getEquipment() {
        return this.equipment;
    }

    public void setEquipment(@NotNull List<ItemStack> equipment) {
        this.equipment = (List)equipment.stream().map(ItemStack::func_77946_l).collect(ImmutableList.toImmutableList());
    }

    public List<Tuple<EntityType<?>, Integer>> getMobs() {
        return (List)this.mobs.entrySet().stream().map(entry -> new Tuple<EntityType, Integer>((EntityType)entry.getKey(), (Integer)entry.getValue())).sorted(Comparator.comparingInt(Tuple::getB).reversed()).collect(ImmutableList.toImmutableList());
    }

    public void addMob(@NotNull EntityType<?> mobType) {
        this.mobs.merge(mobType, 1, Integer::sum);
    }

    public List<ItemStorage> getLoot() {
        return (List)this.loot.keySet().stream().sorted(Comparator.comparing(ItemStorage::getAmount).reversed()).collect(ImmutableList.toImmutableList());
    }

    public void addLoot(@NotNull List<ItemStack> loot) {
        for (ItemStack stack : loot) {
            ItemStorage storage = new ItemStorage(stack);
            this.loot.merge(storage, storage, (o, n) -> {
                o.setAmount(o.getAmount() + n.getAmount());
                return o;
            });
        }
    }

    public void serializeNBT(@NotNull CompoundNBT compound) {
        compound.func_74778_a(TAG_STATUS, this.status.name());
        compound.func_74768_a(TAG_ID, this.id);
        compound.func_74778_a(TAG_NAME, this.name == null ? "" : this.name);
        CompoundNBT stats = new CompoundNBT();
        for (Map.Entry<StatType, Double> entry : this.stats.entrySet()) {
            stats.func_74780_a(entry.getKey().name().toLowerCase(Locale.ROOT), entry.getValue().doubleValue());
        }
        compound.func_218657_a(TAG_STATS, (INBT)stats);
        ListNBT equipment = new ListNBT();
        for (ItemStack itemStack : this.equipment) {
            equipment.add((Object)itemStack.serializeNBT());
        }
        compound.func_218657_a(TAG_EQUIPMENT, (INBT)equipment);
        ListNBT listNBT = new ListNBT();
        for (Map.Entry<EntityType<?>, Integer> entry : this.mobs.entrySet()) {
            CompoundNBT mob = new CompoundNBT();
            mob.func_74778_a(TAG_TYPE, entry.getKey().getRegistryName().toString());
            mob.func_74768_a(TAG_COUNT, entry.getValue().intValue());
            listNBT.add((Object)mob);
        }
        compound.func_218657_a(TAG_MOBS, (INBT)listNBT);
        ListNBT listNBT2 = new ListNBT();
        for (ItemStorage storage : this.loot.values()) {
            listNBT2.add((Object)StandardFactoryController.getInstance().serialize(storage));
        }
        compound.func_218657_a(TAG_LOOT, (INBT)listNBT2);
    }

    public void deserializeNBT(@NotNull CompoundNBT compound) {
        this.status = (Status)((Object)Enums.getIfPresent(Status.class, (String)compound.func_74779_i(TAG_STATUS)).or((Object)Status.NONE));
        this.id = compound.func_74762_e(TAG_ID);
        this.name = compound.func_74779_i(TAG_NAME);
        if (this.name.isEmpty()) {
            this.name = null;
        }
        this.stats.clear();
        CompoundNBT stats = compound.func_74775_l(TAG_STATS);
        for (StatType stat : StatType.values()) {
            String key = stat.name().toLowerCase(Locale.ROOT);
            if (!stats.func_74764_b(key)) continue;
            this.stats.put(stat, stats.func_74769_h(key));
        }
        this.equipment.clear();
        ListNBT equipment = compound.func_150295_c(TAG_EQUIPMENT, 10);
        for (int i = 0; i < equipment.size(); ++i) {
            this.equipment.add(ItemStack.func_199557_a((CompoundNBT)equipment.func_150305_b(i)));
        }
        this.mobs.clear();
        ListNBT mobs = compound.func_150295_c(TAG_MOBS, 10);
        for (int i = 0; i < mobs.size(); ++i) {
            CompoundNBT mob = mobs.func_150305_b(i);
            ResourceLocation type = new ResourceLocation(mob.func_74779_i(TAG_TYPE));
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(type);
            if (entityType == null) continue;
            this.mobs.put(entityType, mob.func_74762_e(TAG_COUNT));
        }
        this.loot.clear();
        ListNBT loot = compound.func_150295_c(TAG_LOOT, 10);
        for (int i = 0; i < loot.size(); ++i) {
            ItemStorage storage = (ItemStorage)StandardFactoryController.getInstance().deserialize(loot.func_150305_b(i));
            this.loot.put(storage, storage);
        }
    }

    public void serialize(@NotNull PacketBuffer buf) {
        buf.func_150787_b(this.status.ordinal());
        buf.func_150787_b(this.id);
        buf.func_180714_a(this.name == null ? "" : this.name);
        for (StatType stat : StatType.values()) {
            buf.writeDouble(this.stats.getOrDefault((Object)stat, 0.0).doubleValue());
        }
        buf.func_150787_b(this.equipment.size());
        for (ItemStack itemStack : this.equipment) {
            buf.func_150788_a(itemStack);
        }
        buf.func_150787_b(this.mobs.size());
        for (Map.Entry entry : this.mobs.entrySet()) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ENTITIES, (IForgeRegistryEntry)((EntityType)entry.getKey()));
            buf.func_150787_b(((Integer)entry.getValue()).intValue());
        }
        buf.func_150787_b(this.loot.size());
        for (ItemStorage itemStorage : this.loot.values()) {
            StandardFactoryController.getInstance().serialize(buf, itemStorage);
        }
    }

    public void deserialize(@NotNull PacketBuffer buf) {
        int size;
        this.status = Status.values()[buf.func_150792_a()];
        this.id = buf.func_150792_a();
        this.name = buf.func_218666_n();
        if (this.name.isEmpty()) {
            this.name = null;
        }
        this.stats.clear();
        for (StatType stat : StatType.values()) {
            this.stats.put(stat, buf.readDouble());
        }
        this.equipment.clear();
        for (size = buf.func_150792_a(); size > 0; --size) {
            this.equipment.add(buf.func_150791_c());
        }
        this.mobs.clear();
        for (size = buf.func_150792_a(); size > 0; --size) {
            EntityType entityType = (EntityType)buf.readRegistryIdUnsafe(ForgeRegistries.ENTITIES);
            int count = buf.func_150792_a();
            if (entityType == null) continue;
            this.mobs.put(entityType, count);
        }
        this.loot.clear();
        for (size = buf.func_150792_a(); size > 0; --size) {
            ItemStorage storage = (ItemStorage)StandardFactoryController.getInstance().deserialize(buf);
            this.loot.put(storage, storage);
        }
    }

    public static enum Status {
        NONE,
        STARTING,
        IN_PROGRESS,
        RETURNING_HOME,
        COMPLETED,
        KILLED;

    }

    public static enum StatType {
        HEALTH,
        SATURATION;

    }
}

