/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.modules.WindowListRecipes;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.OpenCraftingGUIMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingModuleView
extends AbstractBuildingModuleView {
    private String id;
    private JobEntry jobEntry;
    private Set<CraftingType> recipeTypeSet = new HashSet<CraftingType>();
    protected final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();
    protected final List<IRecipeStorage> disabledRecipes = new ArrayList<IRecipeStorage>();
    private int maxRecipes;
    private boolean isVisible = false;

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.jobEntry = buf.readBoolean() ? (JobEntry)buf.readRegistryIdSafe(JobEntry.class) : null;
        this.recipeTypeSet.clear();
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            CraftingType type = (CraftingType)buf.readRegistryIdUnsafe(MinecoloniesAPIProxy.getInstance().getCraftingTypeRegistry());
            if (type == null) continue;
            this.recipeTypeSet.add(type);
        }
        this.recipes.clear();
        this.disabledRecipes.clear();
        int recipesSize = buf.readInt();
        for (int i = 0; i < recipesSize; ++i) {
            IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf.func_150793_b());
            if (storage == null) continue;
            this.recipes.add(storage);
        }
        int disabledRecipeSize = buf.readInt();
        for (int i = 0; i < disabledRecipeSize; ++i) {
            IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf.func_150793_b());
            if (storage == null) continue;
            this.disabledRecipes.add(storage);
        }
        this.maxRecipes = buf.readInt();
        this.id = buf.func_150789_c(Short.MAX_VALUE);
        this.isVisible = buf.readBoolean();
    }

    @Nullable
    public JobEntry getJobEntry() {
        return this.jobEntry;
    }

    public boolean isRecipeAlterationAllowed() {
        return !this.recipeTypeSet.isEmpty();
    }

    public boolean canLearn(CraftingType type) {
        return this.getSupportedCraftingTypes().contains((Object)type);
    }

    public Set<CraftingType> getSupportedCraftingTypes() {
        return this.recipeTypeSet;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPageVisible() {
        return this.isVisible;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new WindowListRecipes(this.buildingView, "minecolonies:gui/layouthuts/layoutlistrecipes.xml", this);
    }

    @Override
    public String getIcon() {
        return this.id;
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.recipe." + this.id;
    }

    public List<IRecipeStorage> getRecipes() {
        return this.recipes;
    }

    public void removeRecipe(int index) {
        this.recipes.remove(index);
    }

    public void switchOrder(int i, int j, boolean fullMove) {
        if (fullMove) {
            if (i > j) {
                this.recipes.add(0, this.recipes.remove(i));
            } else {
                this.recipes.add(this.recipes.remove(i));
            }
        } else if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IRecipeStorage storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
        }
    }

    public int getMaxRecipes() {
        return this.maxRecipes;
    }

    public void openCraftingGUI() {
        BlockPos pos = this.buildingView.getPosition();
        Minecraft.func_71410_x().field_71439_g.func_213829_a((INamedContainerProvider)Minecraft.func_71410_x().field_71441_e.func_175625_s(pos));
        Network.getNetwork().sendToServer(new OpenCraftingGUIMessage((AbstractBuildingView)this.buildingView, this.getId()));
    }

    public void toggle(int row) {
        IRecipeStorage storage = this.recipes.get(row);
        if (this.disabledRecipes.contains(storage)) {
            this.disabledRecipes.remove(storage);
        } else {
            this.disabledRecipes.add(storage);
        }
    }

    public boolean isDisabled(IRecipeStorage recipe) {
        return this.disabledRecipes.contains(recipe);
    }
}

