/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingAlchemist
extends AbstractBuilding {
    private static final String ALCHEMIST = "alchemist";
    private final List<BlockPos> soulsand = new ArrayList<BlockPos>();
    private final List<BlockPos> leaves = new ArrayList<BlockPos>();
    private final List<BlockPos> brewingStands = new ArrayList<BlockPos>();

    public BuildingAlchemist(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> itemStack.func_77973_b() instanceof ShearsItem, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.func_77973_b() == Items.field_151075_bm, new Tuple((Object)16, (Object)false));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return ALCHEMIST;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150425_aM) {
            this.soulsand.add(pos);
        } else if (block.func_203417_a((ITag)BlockTags.field_206952_E)) {
            this.leaves.add(pos);
        } else if (block == Blocks.field_150382_bo) {
            this.brewingStands.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT sandPos = compound.func_150295_c("plantGround", 10);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.soulsand.add(NBTUtil.func_186861_c((CompoundNBT)sandPos.func_150305_b(i).func_74775_l("pos")));
        }
        ListNBT leavesPos = compound.func_150295_c("leaves", 10);
        for (int i = 0; i < leavesPos.size(); ++i) {
            this.leaves.add(NBTUtil.func_186861_c((CompoundNBT)leavesPos.func_150305_b(i).func_74775_l("pos")));
        }
        ListNBT brewingStandPos = compound.func_150295_c("brewingStand", 10);
        for (int i = 0; i < brewingStandPos.size(); ++i) {
            this.brewingStands.add(NBTUtil.func_186861_c((CompoundNBT)brewingStandPos.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT sandCompoundList = new ListNBT();
        for (BlockPos blockPos : this.soulsand) {
            @NotNull CompoundNBT sandCompound = new CompoundNBT();
            sandCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)blockPos));
            sandCompoundList.add((Object)sandCompound);
        }
        compound.func_218657_a("plantGround", (INBT)sandCompoundList);
        @NotNull ListNBT leavesCompoundList = new ListNBT();
        for (BlockPos entry : this.leaves) {
            @NotNull CompoundNBT leaveCompound = new CompoundNBT();
            leaveCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            leavesCompoundList.add((Object)leaveCompound);
        }
        compound.func_218657_a("leaves", (INBT)leavesCompoundList);
        @NotNull ListNBT listNBT = new ListNBT();
        for (BlockPos entry : this.brewingStands) {
            @NotNull CompoundNBT brewingStandCompound = new CompoundNBT();
            brewingStandCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            listNBT.add((Object)brewingStandCompound);
        }
        compound.func_218657_a("brewingStand", (INBT)listNBT);
        return compound;
    }

    public List<BlockPos> getAllSoilPositions() {
        return new ArrayList<BlockPos>(this.soulsand);
    }

    public List<BlockPos> getAllLeavePositions() {
        return new ArrayList<BlockPos>(this.leaves);
    }

    public List<BlockPos> getAllBrewingStandPositions() {
        return new ArrayList<BlockPos>(this.brewingStands);
    }

    public void removeBrewingStand(BlockPos pos) {
        this.brewingStands.remove(pos);
    }

    public void removeSoilPosition(BlockPos pos) {
        this.soulsand.remove(pos);
    }

    public void removeLeafPosition(BlockPos pos) {
        this.leaves.remove(pos);
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return recipe.getPrimaryOutput().func_77973_b() == ModItems.magicpotion;
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly() {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly());
            recipes.add(new GenericRecipe(null, new ItemStack((IItemProvider)ModItems.mistletoe), Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack((IItemProvider)Items.field_151097_aZ))), 1, Blocks.field_196642_W, null, Collections.emptyList(), -1));
            recipes.add(new GenericRecipe(null, new ItemStack((IItemProvider)Items.field_151075_bm, 4), Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack((IItemProvider)Items.field_151075_bm))), 1, Blocks.field_150425_aM, null, Collections.emptyList(), -1));
            return recipes;
        }
    }

    public static class BrewingModule
    extends AbstractCraftingBuildingModule.Brewing {
        public BrewingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

