/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.Optional;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingBlacksmith
extends AbstractBuilding {
    private static final String BLACKSMITH = "blacksmith";

    public BuildingBlacksmith(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BLACKSMITH;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_BLACKSMITH).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            if (recipe.matchesInput(OptionalPredicate.failIf(input -> input.func_77973_b() == Items.field_151116_aA)).equals(Optional.of(false))) {
                return false;
            }
            if (recipe.matchesOutput(OptionalPredicate.passIf(output -> output.func_77973_b() instanceof ToolItem || output.func_77973_b() instanceof SwordItem || output.func_77973_b() instanceof ArmorItem || output.func_77973_b() instanceof HoeItem || output.func_77973_b() instanceof ShieldItem || Compatibility.isTinkersWeapon(output))).equals(Optional.of(true))) {
                return true;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_BLACKSMITH).orElse(false);
        }
    }
}

