/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.WorkAtHomeBuildingModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.HayBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingCombatAcademy
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "combatacademy";
    private static final String DESC = "combatacademy";
    private final List<BlockPos> fightingPos = new ArrayList<BlockPos>();
    private final BiMap<Integer, Integer> trainingPartners = HashBiMap.create();

    public BuildingCombatAcademy(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof CarvedPumpkinBlock && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof HayBlock) {
            this.fightingPos.add(pos.func_177977_b());
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.fightingPos.clear();
        ListNBT targetList = compound.func_150295_c("combatTarget", 10);
        this.fightingPos.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListNBT partnersTagList = compound.func_150295_c("combatPartner", 10);
        this.trainingPartners.putAll(NBTUtils.streamCompound(partnersTagList).collect(Collectors.toMap(targetCompound -> targetCompound.func_74762_e("combatPartner1"), targetCompound -> targetCompound.func_74762_e("combatPartner2"))));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT targetList = this.fightingPos.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "target", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("combatTarget", (INBT)targetList);
        ListNBT partnersTagList = this.trainingPartners.entrySet().stream().map(BuildingCombatAcademy::writePartnerTupleToNBT).collect(NBTUtils.toListNBT());
        compound.func_218657_a("combatPartner", (INBT)partnersTagList);
        return compound;
    }

    private static CompoundNBT writePartnerTupleToNBT(Map.Entry<Integer, Integer> tuple) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("combatPartner1", tuple.getKey().intValue());
        compound.func_74768_a("combatPartner2", tuple.getValue().intValue());
        return compound;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return "combatacademy";
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public BlockPos getRandomCombatTarget(Random random) {
        if (!this.fightingPos.isEmpty()) {
            return this.fightingPos.get(random.nextInt(this.fightingPos.size()));
        }
        return null;
    }

    public AbstractEntityCitizen getRandomCombatPartner(AbstractEntityCitizen citizen) {
        ICitizenData citizenData = citizen.getCitizenData();
        if (citizenData != null) {
            ICitizenData partner = this.getFirstModuleOccurance(WorkAtHomeBuildingModule.class).getAssignedCitizen().stream().filter(data -> data.getId() != citizenData.getId()).filter(data -> !this.trainingPartners.containsKey((Object)data.getId())).filter(data -> !this.trainingPartners.containsValue((Object)data.getId())).findFirst().orElse(null);
            if (partner != null) {
                this.trainingPartners.put((Object)citizenData.getId(), (Object)partner.getId());
                return partner.getEntity().orElse(null);
            }
            return null;
        }
        return null;
    }

    public boolean hasCombatPartner(AbstractEntityCitizen citizen) {
        return this.getCombatPartner(citizen) != null;
    }

    public AbstractEntityCitizen getCombatPartner(AbstractEntityCitizen citizen) {
        ICitizenData data = citizen.getCitizenData();
        if (data != null) {
            int citizenId;
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.get((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.inverse().get((Object)data.getId());
            } else {
                return null;
            }
            ICitizenData citizenData = this.getFirstModuleOccurance(WorkAtHomeBuildingModule.class).getAssignedCitizen().stream().filter(cit -> cit.getId() != data.getId()).filter(cit -> cit.getId() == citizenId).findFirst().orElse(null);
            if (citizenData != null) {
                return citizenData.getEntity().orElse(null);
            }
        }
        return null;
    }

    public void resetPartner(AbstractEntityCitizen worker) {
        ICitizenData data = worker.getCitizenData();
        if (data != null) {
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                this.trainingPartners.remove((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                this.trainingPartners.inverse().remove((Object)data.getId());
            }
        }
    }
}

