/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.mobs.norsemen.EntityNorsemenArcher;
import com.minecolonies.coremod.entity.mobs.norsemen.EntityNorsemenChief;
import com.minecolonies.coremod.entity.mobs.norsemen.EntityShieldmaiden;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NorsemenRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation NORSEMEN_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "norsemen_raid");

    public NorsemenRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return NORSEMEN_RAID_EVENT_TYPE_ID;
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.func_186743_c(true);
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.func_70089_S()) {
            entity.func_70106_y();
            return;
        }
        if (entity instanceof EntityNorsemenChief && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityNorsemenArcher && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityShieldmaiden && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.func_110124_au());
            return;
        }
        entity.func_70106_y();
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob)) {
            return;
        }
        if (entity instanceof EntityNorsemenChief) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityNorsemenArcher) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityShieldmaiden) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static NorsemenRaidEvent loadFromNBT(IColony colony, CompoundNBT compound) {
        NorsemenRaidEvent event = new NorsemenRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.SHIELDMAIDEN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.NORSEMEN_ARCHER;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.NORSEMEN_CHIEF;
    }

    @Override
    protected IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent("com.minecolonies.coremod.raid.norsemen.name");
    }
}

