/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemBuildingDataStore
implements IRequestSystemBuildingDataStore {
    private IToken<?> id;
    private final Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType;
    private final Map<Integer, Collection<IToken<?>>> openRequestsByCitizen;
    private final Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen;
    private final Map<IToken<?>, Integer> citizenByOpenRequest;

    public StandardRequestSystemBuildingDataStore(IToken<?> id, Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType, Map<Integer, Collection<IToken<?>>> openRequestsByCitizen, Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen, Map<IToken<?>, Integer> citizenByOpenRequest) {
        this.id = id;
        this.openRequestsByRequestableType = openRequestsByRequestableType;
        this.openRequestsByCitizen = openRequestsByCitizen;
        this.completedRequestsByCitizen = completedRequestsByCitizen;
        this.citizenByOpenRequest = citizenByOpenRequest;
    }

    public StandardRequestSystemBuildingDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    @Override
    public Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.openRequestsByRequestableType;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.openRequestsByCitizen;
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.completedRequestsByCitizen;
    }

    @Override
    public Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.citizenByOpenRequest;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemBuildingDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemBuildingDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemBuildingDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemBuildingDataStore();
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemBuildingDataStore standardRequestSystemBuildingDataStore) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("Token", (INBT)controller.serialize(standardRequestSystemBuildingDataStore.id));
            compound.func_218657_a("OpenRequestByRequestableType", (INBT)standardRequestSystemBuildingDataStore.openRequestsByRequestableType.keySet().stream().map(typeToken -> {
                CompoundNBT entryCompound = new CompoundNBT();
                entryCompound.func_218657_a("Token", (INBT)controller.serialize(typeToken));
                entryCompound.func_218657_a("List", (INBT)((Collection)standardRequestSystemBuildingDataStore.openRequestsByRequestableType.get(typeToken)).stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            compound.func_218657_a("OpenRequestByCitizen", (INBT)standardRequestSystemBuildingDataStore.openRequestsByCitizen.keySet().stream().map(integer -> {
                CompoundNBT entryCompound = new CompoundNBT();
                entryCompound.func_218657_a("Token", (INBT)controller.serialize(integer));
                entryCompound.func_218657_a("List", (INBT)((Collection)standardRequestSystemBuildingDataStore.openRequestsByCitizen.get(integer)).stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            compound.func_218657_a("CompletedRequestByCitizen", (INBT)standardRequestSystemBuildingDataStore.completedRequestsByCitizen.keySet().stream().map(integer -> {
                CompoundNBT entryCompound = new CompoundNBT();
                entryCompound.func_218657_a("Token", (INBT)controller.serialize(integer));
                entryCompound.func_218657_a("List", (INBT)((Collection)standardRequestSystemBuildingDataStore.completedRequestsByCitizen.get(integer)).stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            compound.func_218657_a("CitizenByOpenRequest", (INBT)standardRequestSystemBuildingDataStore.citizenByOpenRequest.keySet().stream().map(iToken -> {
                CompoundNBT entryCompound = new CompoundNBT();
                entryCompound.func_218657_a("Token", (INBT)controller.serialize(iToken));
                entryCompound.func_218657_a("Value", (INBT)controller.serialize((Integer)standardRequestSystemBuildingDataStore.citizenByOpenRequest.get(iToken)));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemBuildingDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.func_74775_l("Token"));
            Map<TypeToken<?>, Collection<IToken<?>>> openRequestsByRequestableType = NBTUtils.streamCompound(nbt.func_150295_c("OpenRequestByRequestableType", 10)).map(CompoundNBT2 -> {
                TypeToken key = (TypeToken)controller.deserialize(CompoundNBT2.func_74775_l("Token"));
                Collection values = NBTUtils.streamCompound(CompoundNBT2.func_150295_c("List", 10)).map(elementCompound -> (IToken)controller.deserialize((CompoundNBT)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            Map<Integer, Collection<IToken<?>>> openRequestsByCitizen = NBTUtils.streamCompound(nbt.func_150295_c("OpenRequestByCitizen", 10)).map(CompoundNBT2 -> {
                Integer key = (Integer)controller.deserialize(CompoundNBT2.func_74775_l("Token"));
                Collection values = NBTUtils.streamCompound(CompoundNBT2.func_150295_c("List", 10)).map(elementCompound -> (IToken)controller.deserialize((CompoundNBT)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            Map<Integer, Collection<IToken<?>>> completedRequestsByCitizen = NBTUtils.streamCompound(nbt.func_150295_c("CompletedRequestByCitizen", 10)).map(CompoundNBT2 -> {
                Integer key = (Integer)controller.deserialize(CompoundNBT2.func_74775_l("Token"));
                Collection values = NBTUtils.streamCompound(CompoundNBT2.func_150295_c("List", 10)).map(elementCompound -> (IToken)controller.deserialize((CompoundNBT)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)key, (Object)values);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            Map<IToken<?>, Integer> citizenByOpenRequest = NBTUtils.streamCompound(nbt.func_150295_c("CitizenByOpenRequest", 10)).map(CompoundNBT2 -> {
                IToken key = (IToken)controller.deserialize(CompoundNBT2.func_74775_l("Token"));
                Integer value = (Integer)controller.deserialize(CompoundNBT2.func_74775_l("Value"));
                return new Tuple((Object)key, (Object)value);
            }).collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
            return new StandardRequestSystemBuildingDataStore(token, openRequestsByRequestableType, openRequestsByCitizen, completedRequestsByCitizen, citizenByOpenRequest);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestSystemBuildingDataStore input, PacketBuffer packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.openRequestsByRequestableType.size());
            input.openRequestsByRequestableType.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.openRequestsByCitizen.size());
            input.openRequestsByCitizen.forEach((key, value) -> {
                packetBuffer.writeInt(key.intValue());
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.completedRequestsByCitizen.size());
            input.completedRequestsByCitizen.forEach((key, value) -> {
                packetBuffer.writeInt(key.intValue());
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
            packetBuffer.writeInt(input.citizenByOpenRequest.size());
            input.citizenByOpenRequest.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardRequestSystemBuildingDataStore deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            IToken id = (IToken)controller.deserialize(buffer);
            HashMap openRequestsByRequestableType = new HashMap();
            int openRequestsByRequestableTypeSize = buffer.readInt();
            for (int i = 0; i < openRequestsByRequestableTypeSize; ++i) {
                TypeToken key = (TypeToken)controller.deserialize(buffer);
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                openRequestsByRequestableType.put(key, tokens);
            }
            HashMap openRequestsByCitizen = new HashMap();
            int openRequestsByCitizenSize = buffer.readInt();
            for (int i = 0; i < openRequestsByCitizenSize; ++i) {
                int key = buffer.readInt();
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                openRequestsByCitizen.put(key, tokens);
            }
            HashMap completedRequestsByCitizen = new HashMap();
            int completedRequestsByCitizenSize = buffer.readInt();
            for (int i = 0; i < completedRequestsByCitizenSize; ++i) {
                int key = buffer.readInt();
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                completedRequestsByCitizen.put(key, tokens);
            }
            HashMap citizenByOpenRequest = new HashMap();
            int citizenByOpenRequestSize = buffer.readInt();
            for (int i = 0; i < citizenByOpenRequestSize; ++i) {
                citizenByOpenRequest.put((IToken)controller.deserialize(buffer), (Integer)controller.deserialize(buffer));
            }
            return new StandardRequestSystemBuildingDataStore(id, openRequestsByRequestableType, openRequestsByCitizen, completedRequestsByCitizen, citizenByOpenRequest);
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.STANDARD_REQUEST_SYSTEM_BUILDING_DATASTORE_ID;
        }
    }
}

