/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class BuildingRequestResolverFactory
implements IRequestResolverFactory<BuildingRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends BuildingRequestResolver> getFactoryOutputType() {
        return TypeToken.of(BuildingRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public BuildingRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new BuildingRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull BuildingRequestResolver buildingRequestResolver) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_TOKEN, (INBT)controller.serialize(buildingRequestResolver.getId()));
        compound.func_218657_a(NBT_LOCATION, (INBT)controller.serialize(buildingRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public BuildingRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        return new BuildingRequestResolver(location, token);
    }

    @Override
    public void serialize(IFactoryController controller, BuildingRequestResolver input, PacketBuffer packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    public BuildingRequestResolver deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        return new BuildingRequestResolver(location, token);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.BUILDER_BASED_RESOLVER_ID;
    }
}

