/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.journeymap;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.event.ClientChunkUpdatedEvent;
import com.minecolonies.api.colony.event.ColonyViewUpdatedEvent;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.compatibility.journeymap.ColonyBorderMapping;
import com.minecolonies.coremod.compatibility.journeymap.ColonyDeathpoints;
import com.minecolonies.coremod.compatibility.journeymap.Journeymap;
import com.minecolonies.coremod.compatibility.journeymap.JourneymapOptions;
import com.minecolonies.coremod.entity.citizen.VisitorCitizen;
import java.util.Arrays;
import java.util.Set;
import journeymap.client.api.display.Context;
import journeymap.client.api.event.forge.EntityRadarUpdateEvent;
import journeymap.client.api.model.WrappedEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventListener {
    private static final Style JOB_TOOLTIP = Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW).func_240722_b_(Boolean.valueOf(true));
    @NotNull
    private final Journeymap jmap;

    public EventListener(@NotNull Journeymap jmap) {
        this.jmap = jmap;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerLogout(@NotNull ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ColonyDeathpoints.clear();
        this.jmap.getApi().removeAll("minecolonies");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onChunkLoaded(@NotNull ChunkEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            return;
        }
        if (event.getWorld() instanceof World) {
            RegistryKey dimension = ((World)event.getWorld()).func_234923_W_();
            ColonyDeathpoints.updateChunk(this.jmap, (RegistryKey<World>)dimension, event.getChunk());
        }
    }

    @SubscribeEvent
    public void onColonyChunkDataUpdated(@NotNull ClientChunkUpdatedEvent event) {
        RegistryKey dimension = event.getChunk().func_177412_p().func_234923_W_();
        ColonyBorderMapping.updateChunk(this.jmap, (RegistryKey<World>)dimension, event.getChunk());
    }

    @SubscribeEvent
    public void onColonyViewUpdated(@NotNull ColonyViewUpdatedEvent event) {
        IColonyView colony = event.getColony();
        Set<BlockPos> graves = colony.getGraveManager().getGraves().keySet();
        ColonyDeathpoints.updateGraves(this.jmap, colony, graves);
    }

    @SubscribeEvent
    public void onUpdateEntityRadar(@NotNull EntityRadarUpdateEvent event) {
        WrappedEntity wrapper = event.getWrappedEntity();
        LivingEntity entity = (LivingEntity)wrapper.getEntityLivingRef().get();
        if (entity instanceof AbstractEntityCitizen) {
            boolean showName;
            ITextComponent name;
            TranslationTextComponent jobName;
            boolean isVisitor = entity instanceof VisitorCitizen;
            if (isVisitor) {
                if (!JourneymapOptions.getShowVisitors(this.jmap.getOptions())) {
                    wrapper.setDisable(true);
                    return;
                }
                jobName = new TranslationTextComponent("com.minecolonies.coremod.journeymap.visitor");
            } else {
                IJob<?> job;
                String jobId = (String)entity.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_JOB);
                JobEntry jobEntry = (JobEntry)IJobRegistry.getInstance().getValue(new ResourceLocation(jobId));
                IJob<?> iJob = job = jobEntry == null ? null : jobEntry.produceJob(null);
                if (job instanceof AbstractJobGuard ? !JourneymapOptions.getShowGuards(this.jmap.getOptions()) : !JourneymapOptions.getShowCitizens(this.jmap.getOptions())) {
                    wrapper.setDisable(true);
                    return;
                }
                jobName = new TranslationTextComponent(jobEntry == null ? "com.minecolonies.coremod.journeymap.unemployed" : jobEntry.getTranslationKey());
            }
            if (JourneymapOptions.getShowColonistTooltip(this.jmap.getOptions()) && (name = entity.func_200201_e()) != null) {
                wrapper.setEntityToolTips(Arrays.asList(name, jobName.func_230530_a_(JOB_TOOLTIP)));
            }
            boolean bl = showName = event.getActiveUiState().ui.equals((Object)Context.UI.Minimap) ? JourneymapOptions.getShowColonistNameMinimap(this.jmap.getOptions()) : JourneymapOptions.getShowColonistNameFullscreen(this.jmap.getOptions());
            if (!showName) {
                wrapper.setCustomName("");
            }
            if (!isVisitor && JourneymapOptions.getShowColonistTeamColour(this.jmap.getOptions())) {
                wrapper.setColor(entity.func_226263_P_());
            }
        } else if (entity instanceof AbstractEntityMinecoloniesMob) {
            JourneymapOptions.RaiderColor color = JourneymapOptions.getRaiderColor(this.jmap.getOptions());
            if (JourneymapOptions.RaiderColor.NONE.equals((Object)color)) {
                wrapper.setDisable(true);
            } else if (!JourneymapOptions.RaiderColor.HOSTILE.equals((Object)color)) {
                wrapper.setColor(color.getColor().func_240742_a_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            ColonyBorderMapping.updatePending(this.jmap, (RegistryKey<World>)world.func_234923_W_());
        }
    }
}

