/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CitizenChatHandler
implements ICitizenChatHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenChatHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            TranslationTextComponent contentComponent = job != null ? new TranslationTextComponent("block.blockhuttownhall.messageworkerdead", new Object[]{new TranslationTextComponent(job.getJobRegistryEntry().getTranslationKey()), this.citizen.getCitizenData().getName(), Math.round(this.citizen.func_226277_ct_()), Math.round(this.citizen.func_226278_cu_()), Math.round(this.citizen.func_226281_cx_()), new TranslationTextComponent(damageSource.field_76373_n)}) : new TranslationTextComponent("block.blockhuttownhall.messagecolonistdead", new Object[]{this.citizen.getCitizenData().getName(), Math.round(this.citizen.func_226277_ct_()), Math.round(this.citizen.func_226278_cu_()), Math.round(this.citizen.func_226281_cx_()), new TranslationTextComponent(damageSource.field_76373_n)});
            MessageUtils.format((ITextComponent)contentComponent).with(TextFormatting.RED).sendTo(this.citizen.getCitizenColonyHandler().getColony()).forManagers();
        }
    }

    @Override
    public void sendLocalizedChat(String keyIn, Object ... msg) {
        this.sendLocalizedChat((ITextComponent)new TranslationTextComponent(keyIn, msg));
    }

    @Override
    public void sendLocalizedChat(ITextComponent component) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
            MessageUtils.MessageBuilder builder = job != null ? MessageUtils.format(job.getJobRegistryEntry().getTranslationKey(), new Object[0]).append((ITextComponent)new StringTextComponent(" ")).append(this.citizen.func_200201_e()).append((ITextComponent)new StringTextComponent(": ")).append(component) : MessageUtils.format(this.citizen.func_200201_e()).append((ITextComponent)new StringTextComponent(": ")).append(component);
            builder.sendTo(this.citizen.getCitizenColonyHandler().getColony()).forAllPlayers();
        }
    }
}

