/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenMournHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class CitizenMournHandler
implements ICitizenMournHandler {
    private Set<String> deceasedCitizens = new HashSet<String>();
    private boolean isMourning;

    public CitizenMournHandler(ICitizenData data) {
    }

    @Override
    public void read(CompoundNBT compound) {
        this.isMourning = compound.func_74767_n("mourning");
        ListNBT tag = compound.func_150295_c("deceased", 8);
        for (int i = 0; i < tag.size(); ++i) {
            this.deceasedCitizens.add(tag.func_150307_f(i));
        }
    }

    @Override
    public void write(CompoundNBT compound) {
        compound.func_74757_a("mourning", this.isMourning);
        ListNBT deceasedNbt = new ListNBT();
        for (String deceased : this.deceasedCitizens) {
            deceasedNbt.add((Object)StringNBT.func_229705_a_((String)deceased));
        }
        compound.func_218657_a("deceased", (INBT)deceasedNbt);
    }

    @Override
    public void addDeceasedCitizen(String name) {
        this.deceasedCitizens.add(name);
    }

    @Override
    public Set<String> getDeceasedCitizens() {
        return this.deceasedCitizens;
    }

    @Override
    public void removeDeceasedCitizen(String name) {
        this.deceasedCitizens.remove(name);
    }

    @Override
    public void clearDeceasedCitizen() {
        this.deceasedCitizens.clear();
    }

    @Override
    public boolean shouldMourn() {
        return !this.deceasedCitizens.isEmpty();
    }

    @Override
    public boolean isMourning() {
        return this.isMourning;
    }

    @Override
    public void setMourning(boolean mourn) {
        this.isMourning = mourn;
    }
}

