/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleLootTableProvider
extends LootTableProvider {
    protected SimpleLootTableProvider(@NotNull DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected abstract void registerTables(@NotNull LootTableRegistrar var1);

    @NotNull
    protected final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        HashMap tables = new HashMap();
        this.registerTables((id, type, table) -> tables.put(id, Pair.of((Object)type, (Object)table)));
        return tables.entrySet().stream().map(entry -> SimpleLootTableProvider.make((ResourceLocation)entry.getKey(), (LootParameterSet)((Pair)entry.getValue()).getFirst(), (LootTable.Builder)((Pair)entry.getValue()).getSecond())).collect(Collectors.toList());
    }

    private static Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet> make(@NotNull ResourceLocation id, @NotNull LootParameterSet type, @NotNull LootTable.Builder table) {
        return Pair.of(() -> register -> register.accept(id, table), (Object)type);
    }

    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationTracker validationtracker) {
        map.forEach((id, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)id, (LootTable)table));
    }

    public static StandaloneLootEntry.Builder<?> itemStack(@NotNull ItemStack stack) {
        if (!stack.func_190926_b()) {
            StandaloneLootEntry.Builder builder = ItemLootEntry.func_216168_a((IItemProvider)stack.func_77973_b());
            if (stack.func_77942_o()) {
                assert (stack.func_77978_p() != null);
                builder.func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)stack.func_77978_p()));
            }
            if (stack.func_190916_E() > 1) {
                builder.func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)stack.func_190916_E())));
            }
            return builder;
        }
        return EmptyLootEntry.func_216167_a();
    }

    @FunctionalInterface
    public static interface LootTableRegistrar {
        public void register(@NotNull ResourceLocation var1, @NotNull LootParameterSet var2, @NotNull LootTable.Builder var3);
    }
}

