/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.inventory.container.ContainerField;
import com.minecolonies.api.tileentities.AbstractScarecrowTileEntity;
import com.minecolonies.api.tileentities.ScareCrowType;
import com.minecolonies.api.tileentities.ScarecrowFieldStage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScarecrowTileEntity
extends AbstractScarecrowTileEntity {
    private static final int MAX_RANGE = 5;
    private boolean taken = false;
    private boolean doesNeedWork = true;
    private ScarecrowFieldStage fieldStage = ScarecrowFieldStage.EMPTY;
    private int ownerId;
    @NotNull
    private String owner = "";
    private final Random random = new Random();
    private ScareCrowType type;
    @Nullable
    private IColony colony;
    private final ItemStackHandler inventory;
    protected int[] radii = new int[]{5, 5, 5, 5};

    public ScarecrowTileEntity() {
        this.inventory = new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return Tags.Items.SEEDS.func_230235_a_((Object)stack.func_77973_b()) || stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof CropsBlock;
            }
        };
    }

    public static int getMaxRange() {
        return 5;
    }

    @Override
    public void setRadius(Direction direction, int radius) {
        this.radii[direction.func_176736_b()] = radius;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    @Override
    public int getRadius(Direction direction) {
        return this.radii[direction.func_176736_b()];
    }

    @Override
    public boolean isNoPartOfField(@NotNull World world, @NotNull BlockPos position) {
        return world.func_175623_d(position) || ScarecrowTileEntity.isValidDelimiter(world.func_180495_p(position.func_177984_a()).func_177230_c());
    }

    private static boolean isValidDelimiter(Block block) {
        return block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock;
    }

    @Override
    public BlockPos getID() {
        return this.getPosition();
    }

    @Override
    public boolean isTaken() {
        return this.taken;
    }

    @Override
    public void setTaken(boolean taken) {
        this.taken = taken;
        this.func_70296_d();
    }

    @Override
    public void nextState() {
        if (this.getFieldStage().ordinal() + 1 >= ScarecrowFieldStage.values().length) {
            this.doesNeedWork = false;
            this.setFieldStage(ScarecrowFieldStage.values()[0]);
            return;
        }
        this.setFieldStage(ScarecrowFieldStage.values()[this.getFieldStage().ordinal() + 1]);
    }

    @Override
    public ScarecrowFieldStage getFieldStage() {
        return this.fieldStage;
    }

    @Override
    public void setFieldStage(ScarecrowFieldStage fieldStage) {
        this.fieldStage = fieldStage;
        this.func_70296_d();
    }

    @Override
    public boolean needsWork() {
        return this.doesNeedWork;
    }

    @Override
    public void setNeedsWork(boolean needsWork) {
        this.doesNeedWork = needsWork;
        this.func_70296_d();
    }

    @Override
    @Nullable
    public ItemStack getSeed() {
        if (this.inventory.getStackInSlot(0) != ItemStackUtils.EMPTY) {
            return this.inventory.getStackInSlot(0);
        }
        return null;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @Override
    public int getOwnerId() {
        return this.ownerId;
    }

    @Override
    public void setOwner(int ownerId) {
        this.ownerId = ownerId;
        if (this.colony != null) {
            this.owner = this.colony.getCitizenManager().getCivilian(ownerId) == null ? "" : this.colony.getCitizenManager().getCivilian(ownerId).getName();
        }
        this.func_70296_d();
    }

    @Override
    public void setOwner(int ownerId, IColonyView tempColony) {
        this.ownerId = ownerId;
        if (tempColony != null) {
            this.owner = tempColony.getCitizen(ownerId) == null ? "" : tempColony.getCitizen(ownerId).getName();
        }
        this.func_70296_d();
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventory;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        this.func_189515_b(compound);
        if (this.colony != null) {
            compound.func_74768_a("colony", this.colony.getID());
        }
        return new SUpdateTileEntityPacket(this.getPosition(), 0, compound);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT compound = packet.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
        if (compound.func_150296_c().contains("colony")) {
            this.setOwner(this.ownerId, IColonyManager.getInstance().getColonyView(compound.func_74762_e("colony"), (RegistryKey<World>)this.field_145850_b.func_234923_W_()));
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ListNBT inventoryTagList = compound.func_150295_c("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundNBT inventoryCompound = inventoryTagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)inventoryCompound);
            if (ItemStackUtils.getSize(stack) <= 0) {
                this.inventory.setStackInSlot(i, ItemStackUtils.EMPTY);
                continue;
            }
            this.inventory.setStackInSlot(i, stack);
        }
        this.taken = compound.func_74767_n("taken");
        this.fieldStage = ScarecrowFieldStage.values()[compound.func_74762_e("stage")];
        this.radii[3] = compound.func_74764_b("plot_east") ? compound.func_74762_e("plot_east") : 5;
        this.radii[2] = compound.func_74764_b("plot_north") ? compound.func_74762_e("plot_north") : 5;
        this.radii[1] = compound.func_74764_b("plot_west") ? compound.func_74762_e("plot_west") : 5;
        this.radii[0] = compound.func_74764_b("plot_south") ? compound.func_74762_e("plot_south") : 5;
        this.ownerId = compound.func_74762_e("owner");
        this.setOwner(this.ownerId);
        super.func_230337_a_(state, compound);
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        @NotNull ListNBT inventoryTagList = new ListNBT();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            @NotNull CompoundNBT inventoryCompound = new CompoundNBT();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack == ItemStackUtils.EMPTY) {
                new ItemStack((IItemProvider)Blocks.field_150350_a, 0).func_77955_b(inventoryCompound);
            } else {
                stack.func_77955_b(inventoryCompound);
            }
            inventoryTagList.add((Object)inventoryCompound);
        }
        compound.func_218657_a("inventory", (INBT)inventoryTagList);
        compound.func_74757_a("taken", this.taken);
        compound.func_74768_a("stage", this.fieldStage.ordinal());
        compound.func_74768_a("plot_east", this.radii[3]);
        compound.func_74768_a("plot_north", this.radii[2]);
        compound.func_74768_a("plot_west", this.radii[1]);
        compound.func_74768_a("plot_south", this.radii[0]);
        compound.func_74768_a("owner", this.ownerId);
        if (this.colony != null) {
            compound.func_74768_a("colony", this.colony.getID());
        }
        return super.func_189515_b(compound);
    }

    public void setColony(IColony colony) {
        this.colony = colony;
    }

    @Override
    public ScareCrowType getScarecrowType() {
        if (this.type == null) {
            this.type = ScareCrowType.values()[this.random.nextInt(2)];
        }
        return this.type;
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        return new ContainerField(id, inv, this.func_174877_v());
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.owner);
    }
}

