/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigEntry;
import com.supermartijn642.configlib.ConfigFile;
import com.supermartijn642.configlib.ConfigLib;
import com.supermartijn642.configlib.ModConfig;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ConfigBuilder<S> {
    private final String modid;
    private final String name;
    private final String extension;
    private final boolean createSubDirectory;
    private final Map<String, ModConfig.Entry<?, S>> entries = new LinkedHashMap();
    private final Map<List<String>, String> categoryComments = new LinkedHashMap<List<String>, String>();
    private boolean hasBeenBuild = false;

    public ConfigBuilder(String modid, String name, String extension, boolean createSubDirectory) {
        if (modid == null || modid.isEmpty()) {
            throw new IllegalArgumentException("Modid must not be null!");
        }
        this.modid = modid;
        String string = this.name = name == null || name.isEmpty() ? null : name;
        this.extension = extension == null ? "" : (extension.charAt(0) == '.' ? extension.substring(1) : extension);
        this.createSubDirectory = createSubDirectory;
    }

    protected abstract ConfigFile<S> createConfigFile(File var1);

    protected <T> Supplier<T> addEntry(String[] path, ConfigEntry<T, S> configEntry) {
        if (this.entries.containsKey(String.join((CharSequence)".", path))) {
            throw new IllegalStateException("An entry for '" + String.join((CharSequence)".", path) + "' is already defined!");
        }
        if (configEntry.shouldBeSynced() && String.join((CharSequence)".", path).getBytes(StandardCharsets.UTF_8).length > 1024) {
            throw new IllegalArgumentException("Syncable value '" + String.join((CharSequence)".", path) + "''s path must be smaller than 1024 bytes in length!");
        }
        ModConfig.Entry<T, S> entry = new ModConfig.Entry<T, S>(path, configEntry);
        this.entries.put(String.join((CharSequence)".", path), entry);
        return entry::getValue;
    }

    protected void addCategoryComment(String[] path, String comment) {
        List<String> pathKey = Arrays.asList(path);
        if (this.categoryComments.containsKey(pathKey)) {
            throw new IllegalStateException("A comment for category '" + String.join((CharSequence)".", path) + "' is already defined!");
        }
        this.categoryComments.put(pathKey, comment);
    }

    private String getRelativeFileLocation() {
        String cleanModid = this.modid.replaceAll("[\\\\/:*?\"<>|]", "");
        String name = this.name;
        if (name == null || name.isEmpty()) {
            boolean isClientOnly = true;
            boolean isServerOnly = true;
            for (ModConfig.Entry<?, S> entry : this.entries.values()) {
                if (!entry.configEntry.isClientOnly()) {
                    isClientOnly = false;
                }
                if (entry.configEntry.isServerOnly()) continue;
                isServerOnly = false;
            }
            name = isClientOnly ? "client" : (isServerOnly ? "server" : "common");
        }
        return cleanModid + (this.createSubDirectory ? File.separator : Character.valueOf('-')) + name + '.' + this.extension;
    }

    public void build() {
        if (this.hasBeenBuild) {
            throw new IllegalStateException("Config has already been build!");
        }
        this.hasBeenBuild = true;
        String relativeLocation = this.getRelativeFileLocation();
        File configLocation = new File(ConfigLib.getConfigFolder(), relativeLocation);
        ConfigFile<S> configFile = this.createConfigFile(configLocation);
        List<Pair<String[], String>> categoryComments = this.categoryComments.entrySet().stream().map(entry -> Pair.of((Object)((List)entry.getKey()).toArray(new String[0]), entry.getValue())).collect(Collectors.toList());
        ModConfig<S> config = new ModConfig<S>(this.modid, relativeLocation, configFile, new ArrayList(this.entries.values()), categoryComments);
        ConfigLib.addConfig(config);
    }
}

