/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.reflect.Reflection;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.api.capability.IProtectedEntity;
import ovh.corail.tombstone.api.capability.IServantEntity;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.api.capability.ISpellCaster;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.FriendlyAnimalImpl;
import ovh.corail.tombstone.capability.FriendlyAnimalStorage;
import ovh.corail.tombstone.capability.IFriendlyAnimal;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityStorage;
import ovh.corail.tombstone.capability.ServantEntityImpl;
import ovh.corail.tombstone.capability.ServantEntityStorage;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.capability.SpellCasterImpl;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.IntegrationTOP;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.config.TombstoneModConfig;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.loot.AsGiftFunction;
import ovh.corail.tombstone.loot.CheckEnableFunction;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.IsHalloweenFunction;
import ovh.corail.tombstone.loot.KnowledgeRewardFunction;
import ovh.corail.tombstone.loot.PreciseEnchantFunction;
import ovh.corail.tombstone.loot.RandomScrollBuffFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.registry.ClientModEvents;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod(value="tombstone")
public class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static LootFunctionType DELAYED_NBT_LOOT;
    public static LootFunctionType PRECISE_ENCHANT;
    public static LootFunctionType AS_GIFT;
    public static LootFunctionType TRIGGER_CAT_MORNING;
    public static LootFunctionType KNOWLEDGE_REWARD;
    public static LootFunctionType CHECK_ENABLED;
    public static LootFunctionType IS_HALLOWEEN;
    public static LootFunctionType RANDOM_SCROLL_BUFF;
    public static final EnchantmentType TYPE_TOMBSTONE_ALL;

    public ModTombstone() {
        TombstoneAPIProps.COOLDOWN_HANDLER = CooldownHandler.INSTANCE;
        Reflection.initialize((Class[])new Class[]{PerkRegistry.class, PacketHandler.class, ModStats.class, ModTriggers.class, ModTags.class, ModTabs.class});
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, ConfigTombstone.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, ConfigTombstone.GENERAL_SPEC);
        this.registerSharedConfig(context);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::preInit);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::enqueueIMC);
        context.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> ScreenConfig::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (SupportMods.TOP.isLoaded()) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", IntegrationTOP::new);
        }
        if (SupportMods.CURIOS.isLoaded()) {
            CompatibilityCurio.instance.sendIMC();
        }
    }

    private void registerSharedConfig(ModLoadingContext context) {
        context.getActiveContainer().addConfig((ModConfig)new TombstoneModConfig(SharedConfigTombstone.CONFIG_SPEC, context.getActiveContainer()));
    }

    private void preInit(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        CapabilityManager.INSTANCE.register(ISoulConsumer.class, SoulConsumerProvider.NULL_STORAGE, SoulConsumerProvider::getDefault);
        CapabilityManager.INSTANCE.register(IProtectedEntity.class, (Capability.IStorage)new ProtectedEntityStorage(), ProtectedEntityImpl::new);
        CapabilityManager.INSTANCE.register(IServantEntity.class, (Capability.IStorage)new ServantEntityStorage(), ServantEntityImpl::new);
        CapabilityManager.INSTANCE.register(IFriendlyAnimal.class, (Capability.IStorage)new FriendlyAnimalStorage(), FriendlyAnimalImpl::new);
        CapabilityManager.INSTANCE.register(ISpellCaster.class, SpellCasterProvider.NULL_STORAGE, SpellCasterImpl::new);
        PROXY.preInit();
        DELAYED_NBT_LOOT = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)DelayedNBTFunction.RL, (Object)new LootFunctionType((ILootSerializer)DelayedNBTFunction.SERIALIZER));
        PRECISE_ENCHANT = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)PreciseEnchantFunction.RL, (Object)new LootFunctionType((ILootSerializer)PreciseEnchantFunction.SERIALIZER));
        AS_GIFT = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)AsGiftFunction.RL, (Object)new LootFunctionType((ILootSerializer)AsGiftFunction.SERIALIZER));
        TRIGGER_CAT_MORNING = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)TriggerCatMorningFunction.RL, (Object)new LootFunctionType((ILootSerializer)TriggerCatMorningFunction.SERIALIZER));
        KNOWLEDGE_REWARD = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)KnowledgeRewardFunction.RL, (Object)new LootFunctionType((ILootSerializer)KnowledgeRewardFunction.SERIALIZER));
        CHECK_ENABLED = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)CheckEnableFunction.RL, (Object)new LootFunctionType((ILootSerializer)CheckEnableFunction.SERIALIZER));
        IS_HALLOWEEN = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)IsHalloweenFunction.RL, (Object)new LootFunctionType((ILootSerializer)IsHalloweenFunction.SERIALIZER));
        RANDOM_SCROLL_BUFF = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)RandomScrollBuffFunction.RL, (Object)new LootFunctionType((ILootSerializer)RandomScrollBuffFunction.SERIALIZER));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientModEvents::initModels);
    }

    static {
        TYPE_TOMBSTONE_ALL = EnchantmentType.create((String)"type_tombstone_all", p -> p != null && (p.func_77619_b() > 0 || p.func_77639_j() == 1));
    }
}

