/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;

public class BlockDecorativeGrave
extends BlockGraveBase<TileEntityDecorativeGrave> {
    public static final EnumProperty<SoulType> SOUL_TYPE = EnumProperty.func_177709_a((String)"soul_type", SoulType.class);

    public BlockDecorativeGrave(GraveModel graveModel) {
        super(BlockDecorativeGrave.getBuilder(), graveModel);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SOUL_TYPE, (Comparable)((Object)SoulType.NONE)));
    }

    @Override
    protected TileEntityDecorativeGrave createTileGrave(BlockState state, IBlockReader world) {
        return new TileEntityDecorativeGrave();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        IntStream.rangeClosed(0, 1).mapToObj(textureId -> ItemBlockGrave.createDecorativeStack(this.graveModel, textureId)).forEach(arg_0 -> items.add(arg_0));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SOUL_TYPE});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult rayTrace) {
        boolean isSoulReceptacle;
        if (!EntityHelper.isValidPlayer(playerIn) || hand != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        ISoulConsumer soulConsumer = null;
        ItemStack stack = ItemStack.field_190927_a;
        boolean bl = isSoulReceptacle = playerIn.func_184614_ca().func_77973_b() == ModItems.soul_receptacle;
        if (isSoulReceptacle) {
            stack = playerIn.func_184614_ca();
        } else {
            Optional optionalCap;
            Optional optionalCap2;
            ItemStack magicBookSlotContent;
            if (SupportMods.CURIOS.isLoaded() && !(magicBookSlotContent = CompatibilityCurio.instance.getStackInMagicBookSlot(playerIn)).func_190926_b() && (optionalCap2 = magicBookSlotContent.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).filter(ISoulConsumer::isUsingOffhandToEnchant)).isPresent()) {
                soulConsumer = (ISoulConsumer)optionalCap2.get();
                stack = magicBookSlotContent;
            }
            if (stack.func_190926_b() && !playerIn.func_184592_cb().func_190926_b() && (optionalCap = playerIn.func_184592_cb().getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).filter(ISoulConsumer::isUsingOffhandToEnchant)).isPresent()) {
                soulConsumer = (ISoulConsumer)optionalCap.get();
                stack = playerIn.func_184592_cb();
            }
            if (stack.func_190926_b() && !playerIn.func_184614_ca().func_190926_b() && (optionalCap = playerIn.func_184614_ca().getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).filter(c -> true)).isPresent()) {
                if (((ISoulConsumer)optionalCap.get()).isUsingOffhandToEnchant()) {
                    if (!playerIn.field_70170_p.func_201670_d()) {
                        LangKey.MESSAGE_ENCHANT_WITH_OFFHAND.sendMessage(playerIn, new Object[0]);
                    }
                    return ActionResultType.FAIL;
                }
                soulConsumer = (ISoulConsumer)optionalCap.get();
                stack = playerIn.func_184614_ca();
            }
        }
        if (stack.func_190926_b()) {
            return ActionResultType.FAIL;
        }
        if (playerIn.field_70170_p.func_201670_d()) {
            return !EntityHelper.hasGlobalItemCooldown(playerIn, stack) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerIn;
        if (!isSoulReceptacle && soulConsumer == null) {
            return ActionResultType.PASS;
        }
        if (EntityHelper.noGlobalItemCooldown((PlayerEntity)serverPlayer, stack)) {
            if (isSoulReceptacle) {
                EntityHelper.setGlobalItemCooldown((PlayerEntity)serverPlayer, stack, 10);
                if (((SoulType)((Object)state.func_177229_b(SOUL_TYPE))).hasSoul()) {
                    LangKey.MESSAGE_FREE_SOUL_FAILED.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                    return ActionResultType.FAIL;
                }
                LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
                if (bolt != null) {
                    bolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)pos));
                    bolt.func_233623_a_(true);
                    world.func_217376_c((Entity)bolt);
                }
                world.func_180501_a(pos, (BlockState)state.func_206870_a(SOUL_TYPE, (Comparable)((Object)SoulType.WEAK)), 3);
                LangKey.MESSAGE_FREE_SOUL_SUCCESS.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                if (!serverPlayer.func_184812_l_()) {
                    serverPlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
                serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(serverPlayer, 10, (Integer)ConfigTombstone.alignment.pointsFreeSoulReceptacle.get()));
                ModTriggers.FREE_SOUL.trigger(serverPlayer);
                return ActionResultType.SUCCESS;
            }
            if (soulConsumer.isEnchanted(stack)) {
                LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
            } else {
                SoulType soulType = (SoulType)((Object)state.func_177229_b(SOUL_TYPE));
                if (soulType.hasSoul()) {
                    int soulStrength = soulType.getSoulStrenght();
                    if (soulConsumer.canEnchant(world, pos, (PlayerEntity)serverPlayer, stack)) {
                        ISoulConsumer.ConsumeResult consumeResult = soulConsumer.setEnchant(world, pos, serverPlayer, stack, soulStrength);
                        if (consumeResult.result().success()) {
                            if (soulStrength == 2) {
                                if (consumeResult.soulStrength() == 1) {
                                    ModTriggers.KNOWLEDGE_WASTED.trigger(serverPlayer);
                                } else if (consumeResult.soulStrength() > 1) {
                                    ModTriggers.CREATE_ANCIENT_ITEM.trigger(serverPlayer);
                                }
                            }
                            world.func_180501_a(pos, (BlockState)state.func_206870_a(SOUL_TYPE, (Comparable)((Object)soulType.consume(consumeResult.soulStrength()))), 3);
                            Optional.ofNullable(this.getTileEntity(world, pos)).ifPresent(TileEntityDecorativeGrave::resetCheckSoul);
                            ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundCategory.PLAYERS, world, serverPlayer.func_233580_cy_(), 0.5f, 0.5f);
                            LangKey.sendSystemMessage((PlayerEntity)serverPlayer, consumeResult.message());
                            ModTriggers.CONSUME_SOUL.trigger(serverPlayer);
                            int rewardKnowledge = soulConsumer.getKnowledge();
                            serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(serverPlayer, rewardKnowledge, 0));
                        } else {
                            LangKey.sendSystemMessage((PlayerEntity)serverPlayer, consumeResult.message());
                        }
                    } else {
                        LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                    }
                } else {
                    LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendMessage((PlayerEntity)serverPlayer, new Object[0]);
                }
            }
            EntityHelper.setGlobalItemCooldown((PlayerEntity)serverPlayer, stack, 10);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        ItemStack stack;
        if (entity.func_225608_bj_() && !entity.field_70128_L && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && !(stack = ((PlayerEntity)entity).func_184614_ca()).func_190926_b()) {
            stack.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).ifPresent(soulConsumer -> soulConsumer.onSneakGrave(world, pos, (PlayerEntity)entity, stack));
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        String engraved_name;
        if (!world.func_201670_d() && !(engraved_name = EngravableHelper.getEngravedName(stack)).isEmpty()) {
            Optional.ofNullable(this.getTileEntity(world, pos)).ifPresent(tile -> tile.setOwner(Optional.ofNullable(placer).filter(PlayerEntity.class::isInstance).map(PlayerEntity.class::cast).map(p -> p.func_146103_bH().getId()).orElse(null), engraved_name, TimeHelper.systemTime()));
        }
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader blockGetter, BlockPos pos, PlayerEntity player) {
        TileEntity tile = blockGetter.func_175625_s(pos);
        return tile instanceof TileEntityDecorativeGrave && ((TileEntityDecorativeGrave)tile).isOwner(player);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader blockGetter, BlockPos pos) {
        TileEntity tile = blockGetter.func_175625_s(pos);
        return tile instanceof TileEntityDecorativeGrave && ((TileEntityDecorativeGrave)tile).isOwner(player) ? super.func_180647_a(state, player, blockGetter, pos) : 0.0f;
    }

    @Override
    public boolean isToolEffective(BlockState state, ToolType type) {
        return type == ToolType.PICKAXE || type == ToolType.SHOVEL;
    }

    @Override
    public boolean removedByPlayer(BlockState state, World level, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (willHarvest && Optional.ofNullable(this.getTileEntity(level, pos)).map(g -> g.isOwner(player)).orElse(false).booleanValue()) {
            level.func_217378_a(player, 2001, pos, BlockDecorativeGrave.func_196246_j((BlockState)state));
            if (!level.func_201670_d()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return super.removedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    protected void onDrop(World world, BlockPos pos, BlockState oldState) {
        Optional.ofNullable(this.getTileEntity(world, pos)).ifPresent(grave -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)ItemBlockGrave.createDecorativeStack(this.graveModel, (Integer)oldState.func_177229_b((Property)MODEL_TEXTURE), grave.getOwnerName())));
    }

    private static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(20.0f, 1.8E7f).func_235838_a_(s -> 5).func_200947_a(SoundType.field_185851_d);
    }
}

