/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public abstract class BlockGraveBase<T extends TileEntityWritableGrave>
extends HorizontalBlock
implements IBucketPickupHandler,
ILiquidContainer {
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.func_177716_a((String)"is_engraved");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.func_177719_a((String)"model_texture", (int)0, (int)1);
    protected final GraveModel graveModel;

    public BlockGraveBase(AbstractBlock.Properties builder, GraveModel graveModel) {
        super(builder);
        this.graveModel = graveModel;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public T createTileEntity(BlockState state, IBlockReader world) {
        return this.createTileGrave(state, world);
    }

    protected abstract T createTileGrave(BlockState var1, IBlockReader var2);

    public String func_149739_a() {
        return "tombstone.grave." + this.graveModel.func_176610_l();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(ItemBlockGrave.getModelTexture(context.func_195996_i())))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() != this && context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(EngravableHelper.isEngraved(context.func_195996_i())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J, MODEL_TEXTURE, IS_ENGRAVED, WATERLOGGED});
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public boolean canDropFromExplosion(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return false;
    }

    public boolean removedByPlayer(BlockState state, World level, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (player.func_184812_l_()) {
            level.func_217378_a(player, 2001, pos, BlockGraveBase.func_196246_j((BlockState)state));
            if (!level.func_201670_d()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return false;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.func_201670_d() && (ModBlocks.isPlayerGrave(state.func_177230_c()) && !ModBlocks.isPlayerGrave(newState.func_177230_c()) || ModBlocks.isDecorativeGrave(state.func_177230_c()) && !ModBlocks.isDecorativeGrave(newState.func_177230_c()))) {
            if (DeathHandler.INSTANCE.canRemovePlayerGrave(world, pos)) {
                this.onDrop(world, pos, state);
            } else {
                Optional.ofNullable(world.func_175625_s(pos)).ifPresent(grave -> {
                    CompoundNBT oldNbt = grave.func_189515_b(new CompoundNBT());
                    CallbackHandler.addFastCallback(() -> {
                        world.func_175656_a(pos, state);
                        Optional.ofNullable(world.func_175625_s(pos)).ifPresent(newGrave -> {
                            newGrave.func_230337_a_(state, oldNbt);
                            newGrave.func_70296_d();
                            world.func_184138_a(pos, newState, state, 3);
                        });
                    });
                });
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    protected abstract void onDrop(World var1, BlockPos var2, BlockState var3);

    @Nullable
    public T getTileEntity(World world, BlockPos pos) {
        return (T)((Object)((TileEntityWritableGrave)world.func_175625_s(pos)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockState func_196271_a(BlockState olState, Direction facing, BlockState newState, IWorld world, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)olState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(oldPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(olState, facing, newState, world, oldPos, newPos);
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.graveModel.getShape((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J));
    }

    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return PushReaction.IGNORE;
    }

    public boolean isToolEffective(BlockState state, ToolType type) {
        return false;
    }

    public GraveModel getGraveType() {
        return this.graveModel;
    }
}

